/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.FutureResult;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.datatransfer.DataTransferer;

public class ClipboardSynchronizer
implements ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ClipboardSynchronizer");
    private final ClipboardHandler myClipboardHandler = ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isUnitTestMode() ? new HeadlessClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isMac ? new MacClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isXWindow ? new XWinClipboardHandler() : new ClipboardHandler()));

    public static ClipboardSynchronizer getInstance() {
        return (ClipboardSynchronizer)ApplicationManager.getApplication().getComponent(ClipboardSynchronizer.class);
    }

    public void initComponent() {
        this.myClipboardHandler.init();
    }

    public void dispose() {
        this.myClipboardHandler.dispose();
    }

    public void areDataFlavorsAvailableAsync(@NotNull Consumer<Boolean> callback, DataFlavor ... flavors) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/ClipboardSynchronizer", "areDataFlavorsAvailableAsync"));
        }
        if (flavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "areDataFlavorsAvailableAsync"));
        }
        Supplier<Boolean> availabilitySupplier = () -> {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "lambda$areDataFlavorsAvailableAsync$2"));
            }
            return ClipboardUtil.handleClipboardSafely(() -> {
                if (flavors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "lambda$null$0"));
                }
                return this.myClipboardHandler.areDataFlavorsAvailable(flavors);
            }, () -> false);
        };
        Boolean available = availabilitySupplier.get();
        if (available.booleanValue()) {
            callback.consume((Object)available);
        } else {
            AtomicInteger counter = new AtomicInteger();
            Timer timer2 = new Timer(50, event -> {});
            timer2.addActionListener(event -> {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/ClipboardSynchronizer", "lambda$areDataFlavorsAvailableAsync$4"));
                }
                Boolean a = (Boolean)availabilitySupplier.get();
                if (counter.incrementAndGet() > 3 || a.booleanValue()) {
                    timer2.stop();
                }
                callback.consume((Object)a);
            });
            timer2.start();
        }
    }

    public void getContentsAsync(@NotNull Consumer<Transferable> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/ClipboardSynchronizer", "getContentsAsync"));
        }
        Supplier<Transferable> transferableSupplier = () -> ClipboardUtil.handleClipboardSafely(this.myClipboardHandler::getContents, () -> null);
        Transferable transferable = transferableSupplier.get();
        if (transferable != null) {
            callback.consume((Object)transferable);
        } else {
            AtomicInteger counter = new AtomicInteger();
            Timer timer2 = new Timer(50, event -> {});
            timer2.addActionListener(event -> {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/ClipboardSynchronizer", "lambda$getContentsAsync$8"));
                }
                Transferable t2 = (Transferable)transferableSupplier.get();
                if (counter.incrementAndGet() > 3) {
                    timer2.stop();
                }
                callback.consume((Object)t2);
            });
            timer2.start();
        }
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "areDataFlavorsAvailable"));
        }
        return ClipboardUtil.handleClipboardSafely(() -> {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "lambda$areDataFlavorsAvailable$9"));
            }
            return this.myClipboardHandler.areDataFlavorsAvailable(flavors);
        }, () -> false);
    }

    @Nullable
    public Transferable getContents() {
        return ClipboardUtil.handleClipboardSafely(this.myClipboardHandler::getContents, () -> null);
    }

    public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer", "setContent"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer", "setContent"));
        }
        this.myClipboardHandler.setContent(content2, owner);
    }

    public void resetContent() {
        this.myClipboardHandler.resetContent();
    }

    @Nullable
    private static Clipboard getClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (IllegalStateException e2) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e2);
            }
            return null;
        }
    }

    private static boolean areDataFlavorsAvailable(Transferable contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean areDataFlavorsAvailable(Collection<DataFlavor> contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.contains(flavor)) continue;
            return true;
        }
        return false;
    }

    private static class HeadlessClipboardHandler
    extends ClipboardHandler {
        private volatile Transferable myContent = null;

        private HeadlessClipboardHandler() {
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable content2 = this.myContent;
            return content2 != null && ClipboardSynchronizer.areDataFlavorsAvailable(content2, flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            return this.myContent;
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "setContent"));
            }
            this.myContent = content2;
        }

        @Override
        public void resetContent() {
            this.myContent = null;
        }
    }

    private static class XWinClipboardHandler
    extends ClipboardHandler {
        private static final String DATA_TRANSFER_TIMEOUT_PROPERTY = "sun.awt.datatransfer.timeout";
        private static final String LONG_TIMEOUT = "2000";
        private static final String SHORT_TIMEOUT = "100";
        private static final FlavorTable FLAVOR_MAP = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
        private volatile Transferable myCurrentContent = null;

        private XWinClipboardHandler() {
        }

        @Override
        public void init() {
            if (System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY) == null) {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, LONG_TIMEOUT);
            }
        }

        @Override
        public void dispose() {
            this.resetContent();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(currentContent, flavors);
            }
            try {
                Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
                if (contents != null) {
                    return ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
                }
                return super.areDataFlavorsAvailable(flavors);
            }
            catch (NullPointerException e2) {
                LOG.warn("Java bug #6322854", (Throwable)e2);
                return false;
            }
            catch (IllegalArgumentException e3) {
                LOG.warn("Java bug #7173464", (Throwable)e3);
                return false;
            }
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return currentContent;
            }
            try {
                Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
                if (contents != null && contents.isEmpty()) {
                    return null;
                }
                return super.getContents();
            }
            catch (NullPointerException e2) {
                LOG.warn("Java bug #6322854", (Throwable)e2);
                return null;
            }
            catch (IllegalArgumentException e3) {
                LOG.warn("Java bug #7173464", (Throwable)e3);
                return null;
            }
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "setContent"));
            }
            this.myCurrentContent = content2;
            super.setContent(content2, owner);
        }

        @Override
        public void resetContent() {
            this.myCurrentContent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static Collection<DataFlavor> checkContentsQuick() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard == null) {
                return null;
            }
            Class<?> aClass = clipboard.getClass();
            if (!"sun.awt.X11.XClipboard".equals(aClass.getName())) {
                return null;
            }
            Method getClipboardFormats = ReflectionUtil.getDeclaredMethod(aClass, (String)"getClipboardFormats", (Class[])new Class[0]);
            if (getClipboardFormats == null) {
                return null;
            }
            String timeout = System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY);
            System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, SHORT_TIMEOUT);
            try {
                Set<DataFlavor> set2;
                long[] formats = (long[])getClipboardFormats.invoke((Object)clipboard, new Object[0]);
                if (formats == null || formats.length == 0) {
                    Set<DataFlavor> set3 = Collections.emptySet();
                    return set3;
                }
                Set<DataFlavor> set4 = set2 = DataTransferer.getInstance().getFlavorsForFormats(formats, FLAVOR_MAP).keySet();
                return set4;
            }
            catch (IllegalAccessException | IllegalArgumentException formats) {
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
            }
            finally {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, timeout);
            }
            return null;
        }
    }

    private static class MacClipboardHandler
    extends ClipboardHandler {
        private Pair<String, Transferable> myFullTransferable;

        private MacClipboardHandler() {
        }

        @Nullable
        private Transferable doGetContents() {
            return super.getContents();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable contents = this.getContents();
            return contents != null && ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
        }

        @Override
        public Transferable getContents() {
            Transferable transferable = this.doGetContents();
            if (transferable != null && this.myFullTransferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (stringData != null && stringData.equals(this.myFullTransferable.getFirst())) {
                        return (Transferable)this.myFullTransferable.getSecond();
                    }
                }
                catch (UnsupportedFlavorException | IOException e2) {
                    LOG.info((Throwable)e2);
                }
            }
            this.myFullTransferable = null;
            return transferable;
        }

        @Override
        public void resetContent() {
            super.resetContent();
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "setContent"));
            }
            if (Registry.is((String)"ide.mac.useNativeClipboard") && content2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)content2.getTransferData(DataFlavor.stringFlavor);
                    this.myFullTransferable = Pair.create((Object)stringData, (Object)content2);
                    super.setContent(new StringSelection(stringData), owner);
                }
                catch (UnsupportedFlavorException | IOException e2) {
                    LOG.info((Throwable)e2);
                }
            } else {
                this.myFullTransferable = null;
                super.setContent(content2, owner);
            }
        }

        @Nullable
        private static Transferable getContentsSafe() {
            FutureResult result2 = new FutureResult();
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                Transferable transferable = MacClipboardHandler.getClipboardContentNatively();
                if (transferable != null) {
                    result2.set((Object)transferable);
                }
            });
            try {
                return (Transferable)result2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        @Nullable
        private static Transferable getClipboardContentNatively() {
            String plainText = "public.utf8-plain-text";
            ID pasteboard = Foundation.invoke((String)"NSPasteboard", (String)"generalPasteboard", (Object[])new Object[0]);
            ID types = Foundation.invoke((ID)pasteboard, (String)"types", (Object[])new Object[0]);
            ID count = Foundation.invoke((ID)types, (String)"count", (Object[])new Object[0]);
            ID plainTextType = null;
            for (int i2 = 0; i2 < count.intValue(); ++i2) {
                ID each = Foundation.invoke((ID)types, (String)"objectAtIndex:", (Object[])new Object[]{i2});
                String eachType = Foundation.toStringViaUTF8((ID)each);
                if (!plainText.equals(eachType)) continue;
                plainTextType = each;
                break;
            }
            StringSelection result2 = null;
            if (plainTextType != null) {
                ID text2 = Foundation.invoke((ID)pasteboard, (String)"stringForType:", (Object[])new Object[]{plainTextType});
                String value2 = Foundation.toStringViaUTF8((ID)text2);
                if (value2 == null) {
                    LOG.info(String.format("[Clipboard] Strange string value (null?) for type: %s", plainTextType));
                } else {
                    result2 = new StringSelection(value2);
                }
            }
            return result2;
        }
    }

    private static class ClipboardHandler {
        private ClipboardHandler() {
        }

        public void init() {
        }

        public void dispose() {
        }

        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "areDataFlavorsAvailable"));
            }
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard == null) {
                return false;
            }
            for (DataFlavor flavor : flavors) {
                if (!clipboard.isDataFlavorAvailable(flavor)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Transferable getContents() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            return clipboard == null ? null : clipboard.getContents(this);
        }

        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "setContent"));
            }
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard != null) {
                clipboard.setContents(content2, owner);
            }
        }

        public void resetContent() {
        }
    }
}

