/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private final List<Transferable> myData = new ArrayList<Transferable>();
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private final ClipboardSynchronizer myClipboardSynchronizer;
    private boolean myOwnContent = false;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    public CopyPasteManagerEx(ClipboardSynchronizer clipboardSynchronizer) {
        this.myClipboardSynchronizer = clipboardSynchronizer;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        this.myClipboardSynchronizer.resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/CopyPasteManagerEx", "addContentChangedListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/CopyPasteManagerEx", "removeContentChangedListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/CopyPasteManagerEx", "areDataFlavorsAvailable"));
        }
        return flavors.length > 0 && this.myClipboardSynchronizer.areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/CopyPasteManagerEx", "setContents"));
        }
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content2);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element) {
        for (CutElementMarker marker : (CutElementMarker[])Extensions.getExtensions((ExtensionPointName)CutElementMarker.EP_NAME)) {
            if (!marker.isCutElement(element)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        for (Transferable data : this.myData) {
            if (!(data instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content2) {
        this.myClipboardSynchronizer.setContent(content2, this);
        this.myOwnContent = true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 6[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/CopyPasteManagerEx", "addToTheTopOfTheStack"));
        }
        this.myData.add(0, content2);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/ide/CopyPasteManagerEx", "merge"));
        }
        if (oldData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldData", "com/intellij/ide/CopyPasteManagerEx", "merge"));
        }
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(Transferable content2) {
        try {
            return (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private void deleteAfterAllowedMaximum() {
        int max = UISettings.getInstance().getMaxClipboardContents();
        for (int i2 = this.myData.size() - 1; i2 >= max; --i2) {
            this.myData.remove(i2);
        }
    }

    public Transferable getContents() {
        return this.myClipboardSynchronizer.getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/intellij/ide/CopyPasteManagerEx", "getContents"));
        }
        if (this.areDataFlavorsAvailable(flavor)) {
            try {
                Transferable contents = this.getContents();
                if (contents != null) {
                    Object data = contents.getTransferData(flavor);
                    return (T)data;
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Transferable[] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Comparing.equal((String)clipString, (String)CopyPasteManagerEx.getStringContent(this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        Transferable[] transferableArray = this.myData.toArray(new Transferable[this.myData.size()]);
        if (transferableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteManagerEx", "getAllContents"));
        }
        return transferableArray;
    }

    public void removeContent(Transferable t2) {
        Transferable current = this.myData.isEmpty() ? null : this.myData.get(0);
        this.myData.remove(t2);
        if (Comparing.equal((Object)t2, (Object)current)) {
            Transferable newContent = !this.myData.isEmpty() ? this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current, newContent);
        }
    }

    public void moveContentToStackTop(Transferable t2) {
        Transferable current;
        Transferable transferable = current = this.myData.isEmpty() ? null : this.myData.get(0);
        if (!Comparing.equal((Object)t2, (Object)current)) {
            this.myData.remove(t2);
            this.myData.add(0, t2);
            this.setSystemClipboardContent(t2);
            this.fireContentChanged(current, t2);
        } else {
            this.setSystemClipboardContent(t2);
        }
    }
}

