/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

class CustomHrView
extends View {
    private Color myColor;
    private float topMargin;
    private float bottomMargin;
    private float leftMargin;
    private float rightMargin;
    private int alignment = 1;
    private String noshade = "true";
    private int size = 0;
    private static final int SPACE_ABOVE = 3;
    private static final int SPACE_BELOW = 3;
    private AttributeSet attr;

    public CustomHrView(Element elem, Color color) {
        super(elem);
        this.myColor = color;
    }

    @Override
    public void paint(Graphics g2, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int x2 = 0;
        int y2 = alloc.y + 3 + (int)this.topMargin;
        int width = alloc.width - (int)(this.leftMargin + this.rightMargin);
        int height = 1;
        if (this.size > 0) {
            height = this.size;
        }
        switch (this.alignment) {
            case 1: {
                x2 = alloc.x + alloc.width / 2 - width / 2;
                break;
            }
            case 2: {
                x2 = alloc.x + alloc.width - width - (int)this.rightMargin;
                break;
            }
            default: {
                x2 = alloc.x + (int)this.leftMargin;
            }
        }
        if (this.noshade != null) {
            g2.setColor(this.myColor);
            g2.fillRect(x2, y2, width, height);
        } else {
            Color bottom;
            Color top;
            Color bg = this.getContainer().getBackground();
            if (bg == null || bg.equals(Color.white)) {
                top = Color.darkGray;
                bottom = Color.lightGray;
            } else {
                top = Color.darkGray;
                bottom = Color.white;
            }
            g2.setColor(bottom);
            g2.drawLine(x2 + width - 1, y2, x2 + width - 1, y2 + height - 1);
            g2.drawLine(x2, y2 + height - 1, x2 + width - 1, y2 + height - 1);
            g2.setColor(top);
            g2.drawLine(x2, y2, x2 + width - 1, y2);
            g2.drawLine(x2, y2, x2, y2 + height - 1);
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                if (this.size > 0) {
                    return (float)(this.size + 3 + 3) + this.topMargin + this.bottomMargin;
                }
                if (this.noshade != null) {
                    return 8.0f + this.topMargin + this.bottomMargin;
                }
                return 6.0f + this.topMargin + this.bottomMargin;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public int getResizeWeight(int axis) {
        if (axis == 0) {
            return 1;
        }
        if (axis == 1) {
            return 0;
        }
        return 0;
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (axis == 0) {
            return 3000;
        }
        return 0;
    }

    @Override
    public View breakView(int axis, int offset, float pos, float len) {
        return null;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b2) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r2 = a.getBounds();
            if (pos == p1) {
                r2.x += r2.width;
            }
            r2.width = 0;
            return r2;
        }
        return null;
    }

    @Override
    public int viewToModel(float x2, float y2, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x2 < (float)(alloc.x + alloc.width / 2)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attr;
    }
}

