/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.EvaluationFeedbackRequestDialog;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.Prefs;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationSupport
implements ApplicationComponentAdapter {
    private static final long FREE_RUN_AFTER_EVALUATION_EXPIRED = 1800000L;
    private static String ourAppInstanceID = Integer.toHexString(FileUtil.pathHashCode((String)PathManager.getHomePath()));
    private boolean myShowingEvaluationExpired = false;
    private final PropertiesComponent myPropertiesComponent;

    public EvaluationSupport(PropertiesComponent propertiesComponent) {
        this.myPropertiesComponent = propertiesComponent;
    }

    public void initComponent() {
        this.performInit();
    }

    private void performInit() {
        LicenseManager licenseManager = LicenseManager.getInstance();
        if (licenseManager.willLicenseExpire()) {
            Integer followupWhenDaysLeftValue = this.followupWhenDaysLeft();
            if (followupWhenDaysLeftValue == null) {
                followupWhenDaysLeftValue = 10 + (int)(Math.random() * 10.0);
                this.myPropertiesComponent.setValue(EvaluationSupport.followupWhenDaysLeftKey(), followupWhenDaysLeftValue.toString());
                if (!EvaluationSupport.isEAPEval()) {
                    Prefs.putInt((String)(EvaluationSupport.getRegistryKeyPrefix() + EvaluationSupport.followupWhenDaysLeftKey()), (int)(~followupWhenDaysLeftValue.intValue()));
                }
            }
            long followupWhenTimeLeft = (long)followupWhenDaysLeftValue.intValue() * 86400000L;
            IdeEventQueue.getInstance().addIdleListener(() -> {
                Application application = ApplicationManager.getApplication();
                if (application.isDisposed()) {
                    return;
                }
                application.invokeLater(() -> {
                    long now;
                    if (application.isDisposed()) {
                        return;
                    }
                    Date expiration = licenseManager.getEvaluationExpirationDate();
                    if (expiration == null) {
                        return;
                    }
                    long expirationDate = expiration.getTime();
                    if (licenseManager.needDetectCheater()) {
                        this.detectCheater(expirationDate, licenseManager);
                    }
                    if ((now = System.currentTimeMillis()) > expirationDate && now - application.getStartTime() > 1800000L) {
                        this.showMessageAndExitApplication(licenseManager);
                    }
                    if (expirationDate - now < followupWhenTimeLeft && this.followUpKeyValue() == null) {
                        this.encodeExpirationDate(expirationDate);
                        if (licenseManager.needEvaluationFollowUp()) {
                            EvaluationSupport.showEvaluationFollowupMessage(expirationDate, licenseManager.getLicenseFactory().getLicenseMessages().getDefaultEvaluationPeriod());
                        }
                    }
                }, ModalityState.NON_MODAL);
            }, 20000);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void detectCheater(long expirationDate, @NotNull LicenseManager licenseManager) {
        if (licenseManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/EvaluationSupport", "detectCheater"));
        }
        String encodedOriginalExpirationDate = this.followUpKeyValue();
        if (encodedOriginalExpirationDate != null) {
            long twoWeeksStamp;
            long parsedExpirationDate;
            try {
                parsedExpirationDate = Long.parseLong(encodedOriginalExpirationDate, 16);
                twoWeeksStamp = Long.parseLong(this.twoWeeksStamp(), 16);
            }
            catch (NumberFormatException e2) {
                parsedExpirationDate = expirationDate;
                twoWeeksStamp = System.currentTimeMillis();
                this.encodeExpirationDate(expirationDate);
            }
            if (expirationDate != parsedExpirationDate || System.currentTimeMillis() - twoWeeksStamp < -3600000L) {
                void manager;
                this.showMessageAndExitApplication((LicenseManager)manager);
            }
        }
    }

    @Nullable
    private String followUpKeyValue() {
        return this.readPropertyValue(EvaluationSupport.evalFollowupKey());
    }

    private String twoWeeksStamp() {
        return this.readPropertyValue(EvaluationSupport.twoWeeksStampKey());
    }

    private String readPropertyValue(String key) {
        String value2 = this.myPropertiesComponent.getValue(key);
        if (value2 != null) {
            return value2;
        }
        if (EvaluationSupport.isEAPEval()) {
            return null;
        }
        long longValue = Prefs.getLong((String)(EvaluationSupport.getRegistryKeyPrefix() + key), (long)0L) ^ 0xFFFFFFFFFFFFFFFFL;
        return longValue > 0L ? Long.toHexString(longValue) : null;
    }

    private Integer followupWhenDaysLeft() {
        int val;
        String key = EvaluationSupport.followupWhenDaysLeftKey();
        String value2 = this.myPropertiesComponent.getValue(key);
        if (value2 != null) {
            try {
                return Integer.parseInt(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!EvaluationSupport.isEAPEval() && (val = ~Prefs.getInt((String)(EvaluationSupport.getRegistryKeyPrefix() + key), (int)0)) > 0) {
            return val;
        }
        return null;
    }

    private void showMessageAndExitApplication(@NotNull LicenseManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/EvaluationSupport", "showMessageAndExitApplication"));
        }
        if (this.myShowingEvaluationExpired) {
            return;
        }
        this.myShowingEvaluationExpired = true;
        manager.getLicenseFactory().getLicenseMessages().showLicenseExpiredBeforeShutdownNotification(true);
        ((ApplicationImpl)ApplicationManager.getApplication()).exit(true, true, false);
    }

    private static void showEvaluationFollowupMessage(long expirationDate, int defaultPeriod) {
        long issue = expirationDate - (long)defaultPeriod * 86400000L;
        long now = System.currentTimeMillis();
        long using2 = now - issue;
        EvaluationFeedbackRequestDialog dlg = new EvaluationFeedbackRequestDialog((int)(using2 / 86400000L), ApplicationNamesInfo.getInstance().getFullProductName());
        if (dlg.showAndGet()) {
            SendFeedbackAction.launchBrowser(null);
        }
    }

    private void encodeExpirationDate(long expirationDate) {
        if (LicenseManager.getInstance().isEvaluationLicense()) {
            long stamp = System.currentTimeMillis();
            this.myPropertiesComponent.setValue(EvaluationSupport.evalFollowupKey(), Long.toHexString(expirationDate));
            this.myPropertiesComponent.setValue(EvaluationSupport.twoWeeksStampKey(), Long.toHexString(stamp));
            if (!EvaluationSupport.isEAPEval()) {
                String prefix = EvaluationSupport.getRegistryKeyPrefix();
                Prefs.putLong((String)(prefix + EvaluationSupport.evalFollowupKey()), (long)(expirationDate ^ 0xFFFFFFFFFFFFFFFFL));
                Prefs.putLong((String)(prefix + EvaluationSupport.twoWeeksStampKey()), (long)(stamp ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
    }

    private static String getRegistryKeyPrefix() {
        return "JetBrains." + LicenseManager.getInstance().getLicenseFactory().getProductDescriptor().getShortName() + "." + ourAppInstanceID + ".";
    }

    private static String twoWeeksStampKey() {
        return "evlsprt2." + EvaluationSupport.effectiveEvalSelector();
    }

    private static String evalFollowupKey() {
        return "evlsprt." + EvaluationSupport.effectiveEvalSelector();
    }

    private static String followupWhenDaysLeftKey() {
        return "evlsprt3." + EvaluationSupport.effectiveEvalSelector();
    }

    private static String effectiveEvalSelector() {
        return EvaluationSupport.isEAPEval() ? ApplicationInfo.getInstance().getBuild().asString() : LicenseManager.getInstance().getLicenseFactory().getCurrentEvaluationSelector();
    }

    private static boolean isEAPEval() {
        return ApplicationInfoEx.getInstanceEx().isEAP() && !LicenseManager.getInstance().getLicenseFactory().isForceReleaseEvaluationSelector();
    }
}

