/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.GeneralSettingsConfigurableEP;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class GeneralSettingsConfigurable
extends CompositeConfigurable<SearchableConfigurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final ExtensionPointName<GeneralSettingsConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.generalOptionsProvider");
    private MyComponent myComponent = new MyComponent();

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setReopenLastProject(this.myComponent.myChkReopenLastProject.isSelected());
        settings.setSupportScreenReaders(this.myComponent.myChkSupportScreenReaders.isSelected());
        settings.setSyncOnFrameActivation(this.myComponent.myChkSyncOnFrameActivation.isSelected());
        settings.setSaveOnFrameDeactivation(this.myComponent.myChkSaveOnFrameDeactivation.isSelected());
        settings.setConfirmExit(this.myComponent.myConfirmExit.isSelected());
        settings.setConfirmOpenNewProject(this.getConfirmOpenNewProject());
        settings.setProcessCloseConfirmation(this.getProcessCloseConfirmation());
        settings.setAutoSaveIfInactive(this.myComponent.myChkAutoSaveIfInactive.isSelected());
        try {
            settings.setInactiveTimeout(Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.setUseSafeWrite(this.myComponent.myChkUseSafeWrite.isSelected());
    }

    private GeneralSettings.ProcessCloseConfirmation getProcessCloseConfirmation() {
        if (this.myComponent.myTerminateProcessJBRadioButton.isSelected()) {
            return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        }
        if (this.myComponent.myDisconnectJBRadioButton.isSelected()) {
            return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
        }
        return GeneralSettings.ProcessCloseConfirmation.ASK;
    }

    @GeneralSettings.OpenNewProjectOption
    private int getConfirmOpenNewProject() {
        if (this.myComponent.myConfirmWindowToOpenProject.isSelected()) {
            return -1;
        }
        if (this.myComponent.myOpenProjectInNewWindow.isSelected()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        boolean isModified = settings.isReopenLastProject() != this.myComponent.myChkReopenLastProject.isSelected();
        isModified |= settings.isSupportScreenReaders() != this.myComponent.myChkSupportScreenReaders.isSelected();
        isModified |= settings.isSyncOnFrameActivation() != this.myComponent.myChkSyncOnFrameActivation.isSelected();
        isModified |= settings.isSaveOnFrameDeactivation() != this.myComponent.myChkSaveOnFrameDeactivation.isSelected();
        isModified |= settings.isAutoSaveIfInactive() != this.myComponent.myChkAutoSaveIfInactive.isSelected();
        isModified |= settings.isConfirmExit() != this.myComponent.myConfirmExit.isSelected();
        isModified |= settings.getConfirmOpenNewProject() != this.getConfirmOpenNewProject();
        isModified |= settings.getProcessCloseConfirmation() != this.getProcessCloseConfirmation();
        isModified |= this.isModified(this.myComponent.myTfInactiveTimeout, settings.getInactiveTimeout(), GeneralSettings.SAVE_FILES_AFTER_IDLE_SEC);
        return isModified |= settings.isUseSafeWrite() != this.myComponent.myChkUseSafeWrite.isSelected();
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyComponent();
        }
        this.myComponent.myChkAutoSaveIfInactive.addChangeListener(e2 -> this.myComponent.myTfInactiveTimeout.setEditable(this.myComponent.myChkAutoSaveIfInactive.isSelected()));
        List list2 = this.getConfigurables();
        if (!list2.isEmpty()) {
            this.myComponent.myPluginOptionsPanel.setLayout(new GridLayout(list2.size(), 1));
            for (Configurable c2 : list2) {
                this.myComponent.myPluginOptionsPanel.add(c2.createComponent());
            }
        }
        return this.myComponent.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.general", (Object[])new Object[0]);
    }

    @Override
    public void reset() {
        super.reset();
        GeneralSettings settings = GeneralSettings.getInstance();
        this.myComponent.myChkReopenLastProject.setSelected(settings.isReopenLastProject());
        this.myComponent.myChkSupportScreenReaders.setSelected(settings.isSupportScreenReaders());
        this.myComponent.myChkSyncOnFrameActivation.setSelected(settings.isSyncOnFrameActivation());
        this.myComponent.myChkSaveOnFrameDeactivation.setSelected(settings.isSaveOnFrameDeactivation());
        this.myComponent.myChkAutoSaveIfInactive.setSelected(settings.isAutoSaveIfInactive());
        this.myComponent.myTfInactiveTimeout.setText(Integer.toString(settings.getInactiveTimeout()));
        this.myComponent.myTfInactiveTimeout.setEditable(settings.isAutoSaveIfInactive());
        this.myComponent.myChkUseSafeWrite.setSelected(settings.isUseSafeWrite());
        this.myComponent.myConfirmExit.setSelected(settings.isConfirmExit());
        switch (settings.getConfirmOpenNewProject()) {
            case -1: {
                this.myComponent.myConfirmWindowToOpenProject.setSelected(true);
                break;
            }
            case 0: {
                this.myComponent.myOpenProjectInNewWindow.setSelected(true);
                break;
            }
            case 1: {
                this.myComponent.myOpenProjectInSameWindow.setSelected(true);
            }
        }
        switch (settings.getProcessCloseConfirmation()) {
            case TERMINATE: {
                this.myComponent.myTerminateProcessJBRadioButton.setSelected(true);
                break;
            }
            case DISCONNECT: {
                this.myComponent.myDisconnectJBRadioButton.setSelected(true);
                break;
            }
            case ASK: {
                this.myComponent.myAskJBRadioButton.setSelected(true);
            }
        }
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.general" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/GeneralSettingsConfigurable", "getHelpTopic"));
        }
        return "preferences.general";
    }

    @NotNull
    public String getId() {
        String string2 = this.getHelpTopic();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/GeneralSettingsConfigurable", "getId"));
        }
        return string2;
    }

    @Override
    protected List<SearchableConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    private static class MyComponent {
        private JPanel myPanel;
        private JCheckBox myChkReopenLastProject;
        private JCheckBox myChkSyncOnFrameActivation;
        private JCheckBox myChkSaveOnFrameDeactivation;
        private JCheckBox myChkAutoSaveIfInactive;
        private JTextField myTfInactiveTimeout;
        private JCheckBox myChkUseSafeWrite;
        private JCheckBox myConfirmExit;
        private JPanel myPluginOptionsPanel;
        private JBRadioButton myOpenProjectInNewWindow;
        private JBRadioButton myOpenProjectInSameWindow;
        private JBRadioButton myConfirmWindowToOpenProject;
        private JCheckBox myChkSupportScreenReaders;
        private JBRadioButton myTerminateProcessJBRadioButton;
        private JBRadioButton myDisconnectJBRadioButton;
        private JBRadioButton myAskJBRadioButton;

        public MyComponent() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBRadioButton jBRadioButton;
            JBRadioButton jBRadioButton2;
            JBRadioButton jBRadioButton3;
            JBRadioButton jBRadioButton4;
            JBRadioButton jBRadioButton5;
            JBRadioButton jBRadioButton6;
            JPanel jPanel;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JTextField jTextField;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Startup/Shutdown", (int)0, (int)0, null, null));
            this.myChkReopenLastProject = jCheckBox7 = new JCheckBox();
            jCheckBox7.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.reopen.last.project.on.startup"));
            jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myConfirmExit = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.confirm.application.exit"));
            jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Synchronization", (int)0, (int)0, null, null));
            this.myChkSyncOnFrameActivation = jCheckBox5 = new JCheckBox();
            jCheckBox5.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.synchronize.files.on.frame.activation"));
            jPanel4.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel4.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myChkSaveOnFrameDeactivation = jCheckBox4 = new JCheckBox();
            jCheckBox4.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.on.frame.deactivation"));
            jPanel4.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkAutoSaveIfInactive = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.automatically"));
            jPanel4.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 8, 2, 0, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.inactive.timeout.sec"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfInactiveTimeout = jTextField = new JTextField();
            jTextField.setColumns(10);
            jTextField.setMargin(new Insets(0, 2, 0, 4));
            jPanel5.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
            this.myChkUseSafeWrite = jCheckBox2 = new JCheckBox();
            jCheckBox2.setToolTipText("<html>If this check box is selected, a changed file will be first saved to a temporary file;<br>if the save operation is completed successfully, the original file is deleted, and the temporary file is renamed.</html> ");
            jCheckBox2.setSelected(true);
            jCheckBox2.setText("Use \"safe write\" (save changes to a temporary file first)");
            jPanel4.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Accessibility", (int)0, (int)0, null, null));
            this.myChkSupportScreenReaders = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.support.screen.readers"));
            jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer5 = new Spacer();
            jPanel2.add((Component)spacer5, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myPluginOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Project Opening", (int)0, (int)0, null, null));
            this.myOpenProjectInSameWindow = jBRadioButton6 = new JBRadioButton();
            jBRadioButton6.setText("Open project in the same window");
            jPanel7.add((Component)jBRadioButton6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myConfirmWindowToOpenProject = jBRadioButton5 = new JBRadioButton();
            jBRadioButton5.setText("Confirm window to open project in");
            jPanel7.add((Component)jBRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer6 = new Spacer();
            jPanel7.add((Component)spacer6, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myOpenProjectInNewWindow = jBRadioButton4 = new JBRadioButton();
            jBRadioButton4.setText("Open project in new window");
            jPanel7.add((Component)jBRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel2.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.settings.process.tab.close"), (int)0, (int)0, null, null));
            this.myTerminateProcessJBRadioButton = jBRadioButton3 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.terminate"));
            jPanel8.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDisconnectJBRadioButton = jBRadioButton2 = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.disaconnect"));
            jPanel8.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAskJBRadioButton = jBRadioButton = new JBRadioButton();
            this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, ResourceBundle.getBundle("messages/IdeBundle").getString("radio.process.close.ask"));
            jPanel8.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2 = new ButtonGroup();
            buttonGroup2.add((AbstractButton)jBRadioButton4);
            buttonGroup2.add((AbstractButton)jBRadioButton6);
            buttonGroup2.add((AbstractButton)jBRadioButton5);
            buttonGroup2 = new ButtonGroup();
            buttonGroup2.add((AbstractButton)jBRadioButton3);
            buttonGroup2.add((AbstractButton)jBRadioButton2);
            buttonGroup2.add((AbstractButton)jBRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = -1;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (string2.charAt(i2) == '&') {
                    if (++i2 == string2.length()) break;
                    if (!bl && string2.charAt(i2) != '&') {
                        bl = true;
                        c2 = string2.charAt(i2);
                        n2 = stringBuffer.length();
                    }
                }
                stringBuffer.append(string2.charAt(i2));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n2);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n2 = -1;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (string2.charAt(i2) == '&') {
                    if (++i2 == string2.length()) break;
                    if (!bl && string2.charAt(i2) != '&') {
                        bl = true;
                        c2 = string2.charAt(i2);
                        n2 = stringBuffer.length();
                    }
                }
                stringBuffer.append(string2.charAt(i2));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c2);
                abstractButton.setDisplayedMnemonicIndex(n2);
            }
        }
    }
}

