/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PrivacyPolicy;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.JBALicenseData;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.jetbrains.ls.responses.ObtainAgreementResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.util.JBAClientUtil;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PrivacyPolicyUpdater
implements ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PrivacyPolicyUpdater");
    private ScheduledFuture<?> myPeriodicTask;

    public void initComponent() {
        if (ApplicationInfoImpl.getShadowInstance().isVendorJetBrains()) {
            this.myPeriodicTask = JobScheduler.getScheduler().scheduleWithFixedDelay(PrivacyPolicyUpdater::checkForUpdate, 300000L, 86400000L, TimeUnit.MILLISECONDS);
        }
    }

    private static void checkForUpdate() {
        String errorMessage = null;
        try {
            String licenseId = null;
            String userId = null;
            LicenseSource source = LicenseManager.getInstance().getActualSource();
            if (source != null) {
                LicenseData licData = source.getLicense();
                if (licData instanceof CertKeyLicense) {
                    CertKeyLicense lic = (CertKeyLicense)((Object)licData);
                    String pcode = lic.getProductCode();
                    Date subEnd = lic.getCertKey().getFirstExpiredDate(pcode);
                    if (subEnd != null && !new Date().before(subEnd) && lic.getCertKey().isPerpetualForProduct(pcode, lic.getProductBuildDate())) {
                        return;
                    }
                }
                if (licData instanceof JBALicenseData) {
                    JBALicenseData jbaLicense = (JBALicenseData)licData;
                    userId = jbaLicense.getUserId();
                    licenseId = jbaLicense.getLicenseId();
                }
            }
            if (userId == null) {
                userId = JetprofileSource.getSharedUserId();
            }
            Pair currentPolicy = PrivacyPolicy.getContent();
            String productCode = LicenseManager.getInstance().getLicenseFactory().getProductDescriptor().getProductCode();
            ObtainAgreementResponse response = JBAClientUtil.obtainPrivacyPolicyAgreement(productCode, ((PrivacyPolicy.Version)currentPolicy.getFirst()).toString(), licenseId, userId);
            if (response.getResponseCode() == ResponseCode.OK) {
                String html = response.getDocumentHtml();
                if (html != null && !html.isEmpty()) {
                    PrivacyPolicy.updateText((String)html);
                }
            } else {
                errorMessage = response.getMessage();
            }
        }
        catch (Throwable e2) {
            errorMessage = e2.getMessage();
        }
        if (errorMessage != null) {
            LOG.info("Error updating privacy policy: " + errorMessage);
        }
    }

    public void dispose() {
        ScheduledFuture<?> task2 = this.myPeriodicTask;
        if (task2 != null) {
            this.myPeriodicTask = null;
            task2.cancel(false);
            try {
                task2.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

