/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.AWTEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ProhibitAWTEvents
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ProhibitAWTEvents");
    private final String myActivityName;
    private boolean myReported;

    private ProhibitAWTEvents(@NotNull String activityName) {
        if (activityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/ide/ProhibitAWTEvents", "<init>"));
        }
        this.myActivityName = activityName;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ProhibitAWTEvents", "dispatch"));
        }
        if (!this.myReported) {
            this.myReported = true;
            LOG.error("AWT events are prohibited inside " + this.myActivityName + "; got " + e2);
        }
        return true;
    }

    @NotNull
    public static AccessToken start(@NotNull String activityName) {
        if (activityName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/ide/ProhibitAWTEvents", "start"));
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ProhibitAWTEvents", "start"));
            }
            return accessToken;
        }
        final ProhibitAWTEvents dispatcher = new ProhibitAWTEvents(activityName);
        IdeEventQueue.getInstance().addPostprocessor(dispatcher, null);
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                IdeEventQueue.getInstance().removePostprocessor(dispatcher);
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ProhibitAWTEvents", "start"));
        }
        return accessToken;
    }
}

