/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.LinkedList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SwingCleanuper {
    private final Alarm myAlarm;

    public SwingCleanuper(@NotNull Application application, ProjectManager projectManager) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/ide/SwingCleanuper", "<init>"));
        }
        this.myAlarm = new Alarm((Disposable)application);
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
            }

            public void projectClosed(Project project2) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
                SwingCleanuper.this.myAlarm.addRequest(() -> {
                    StatusBar statusBar;
                    Application app;
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                    IdeFrameImpl frame = (IdeFrameImpl)(window instanceof IdeFrameImpl ? window : SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window));
                    if (frame != null && (app = ApplicationManager.getApplication()) != null && app.isActive() && (statusBar = frame.getStatusBar()) != null) {
                        ((JComponent)statusBar).requestFocus();
                    }
                    SwingUtilities.invokeLater(SwingCleanuper::cleanup);
                }, 2500);
            }
        });
        if (SystemInfo.isMac) {
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (!Registry.is((String)"ide.mac.fix.accessibleLeak")) {
                    return;
                }
                HierarchyEvent he = (HierarchyEvent)event;
                if (BitUtil.isSet((long)he.getChangeFlags(), (long)4L) && he.getComponent() != null && !he.getComponent().isShowing()) {
                    ChangeListener[] changeListeners;
                    Component c2 = he.getComponent();
                    if (c2 instanceof JTextComponent) {
                        CaretListener[] carets;
                        JTextComponent textComponent = (JTextComponent)c2;
                        for (CaretListener each : carets = (CaretListener[])textComponent.getListeners(CaretListener.class)) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            textComponent.removeCaretListener(each);
                        }
                        Document document = textComponent.getDocument();
                        if (document instanceof AbstractDocument) {
                            DocumentListener[] documentListeners;
                            for (DocumentListener each : documentListeners = ((AbstractDocument)document).getDocumentListeners()) {
                                if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                                document.removeDocumentListener(each);
                            }
                        }
                    } else if (c2 instanceof JProgressBar) {
                        JProgressBar bar = (JProgressBar)c2;
                        changeListeners = bar.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            bar.removeChangeListener(each);
                        }
                    } else if (c2 instanceof JSlider) {
                        JSlider slider = (JSlider)c2;
                        changeListeners = slider.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            slider.removeChangeListener(each);
                        }
                    }
                    Field nativeAXResource_Field = null;
                    Field accessibleContext_Field = null;
                    try {
                        nativeAXResource_Field = ReflectionUtil.findField(AccessibleContext.class, Object.class, (String)"nativeAXResource");
                        accessibleContext_Field = ReflectionUtil.findField(Component.class, AccessibleContext.class, (String)"accessibleContext");
                    }
                    catch (NoSuchFieldException document) {
                        // empty catch block
                    }
                    if (accessibleContext_Field != null) {
                        try {
                            Object resource;
                            AccessibleContext ac2 = (AccessibleContext)accessibleContext_Field.get(c2);
                            if (ac2 != null && (ac2 = c2.getAccessibleContext()) != null && (resource = nativeAXResource_Field.get(ac2)) != null && SwingCleanuper.isCAccessible(resource)) {
                                Field accessible = ReflectionUtil.findField(resource.getClass(), Accessible.class, (String)"accessible");
                                accessible.set(resource, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, 32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        ReflectionUtil.resetStaticField(KeyboardFocusManager.class, (String)"newFocusOwner");
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        SwingCleanuper.resetField(focusManager, Component.class, "realOppositeComponent");
        SwingCleanuper.resetField(focusManager, Window.class, "realOppositeWindow");
        try {
            Object helperObject = ReflectionUtil.getStaticFieldValue(BasicPopupMenuUI.class, Object.class, (String)"menuKeyboardHelper");
            if (helperObject != null) {
                SwingCleanuper.resetField(helperObject, Component.class, "lastFocused");
            }
        }
        catch (Exception helperObject) {
            // empty catch block
        }
        try {
            DragGestureRecognizer recognizer = (DragGestureRecognizer)ReflectionUtil.getStaticFieldValue(TransferHandler.class, DragGestureRecognizer.class, (String)"recognizer");
            if (recognizer != null) {
                recognizer.setComponent(null);
            }
        }
        catch (Exception recognizer) {
            // empty catch block
        }
        try {
            SwingCleanuper.fixJTextComponentMemoryLeak();
        }
        catch (Exception recognizer) {
            // empty catch block
        }
        focusManager.setGlobalCurrentFocusCycleRoot(null);
        try {
            Method m2 = ReflectionUtil.getDeclaredMethod(KeyboardFocusManager.class, (String)"setGlobalFocusOwner", (Class[])new Class[]{Component.class});
            m2.invoke((Object)focusManager, new Object[]{null});
        }
        catch (Exception m2) {
            // empty catch block
        }
        ReflectionUtil.resetStaticField(KeyboardFocusManager.class, (String)"newFocusOwner");
        ReflectionUtil.resetStaticField(KeyboardFocusManager.class, (String)"permanentFocusOwner");
        ReflectionUtil.resetStaticField(KeyboardFocusManager.class, (String)"currentFocusCycleRoot");
        assert (Patches.USE_REFLECTION_TO_ACCESS_JDK8);
        LinkedList heavyweightRequests = (LinkedList)ReflectionUtil.getField(KeyboardFocusManager.class, null, LinkedList.class, (String)"heavyweightRequests");
        if (heavyweightRequests != null) {
            LinkedList linkedList = heavyweightRequests;
            synchronized (linkedList) {
                heavyweightRequests.clear();
            }
        }
    }

    private static boolean isCAccessible(Object resource) {
        String name = resource.getClass().getName();
        return SwingCleanuper.isCAccessible(name);
    }

    static boolean isCAccessible(String name) {
        return name.equals("apple.awt.CAccessible") || name.equals("sun.lwawt.macosx.CAccessible");
    }

    private static boolean isCAccessibleListener(EventListener listener2) {
        return listener2 != null && listener2.toString().contains("AXTextChangeNotifier");
    }

    private static void resetField(Object object, Class type, @NonNls String name) {
        try {
            ReflectionUtil.resetField((Object)object, (Field)ReflectionUtil.findField(object.getClass(), (Class)type, (String)name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fixJTextComponentMemoryLeak() {
        JTextComponent component = (JTextComponent)ReflectionUtil.getStaticFieldValue(JTextComponent.class, JTextComponent.class, (String)"focusedComponent");
        if (component != null && !component.isDisplayable()) {
            ReflectionUtil.resetField(JTextComponent.class, JTextComponent.class, (String)"focusedComponent");
        }
    }
}

