/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionMacroManager", storages={@Storage(value="macros.xml")})
public class ActionMacroManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actionMacro.ActionMacroManager");
    private static final String TYPING_SAMPLE = "WWWWWWWWWWWWWWWWWWWW";
    private static final String RECORDED = "Recorded: ";
    private boolean myIsRecording;
    private final ActionManagerEx myActionManager;
    private ActionMacro myLastMacro;
    private ActionMacro myRecordingMacro;
    private ArrayList<ActionMacro> myMacros = new ArrayList();
    private String myLastMacroName = null;
    private boolean myIsPlaying = false;
    @NonNls
    private static final String ELEMENT_MACRO = "macro";
    private final IdeEventQueue.EventDispatcher myKeyProcessor;
    private Set<InputEvent> myLastActionInputEvent = new HashSet<InputEvent>();
    private Widget myWidget;
    private String myLastTyping = "";

    public ActionMacroManager(ActionManagerEx actionManagerEx) {
        this.myActionManager = actionManagerEx;
        this.myActionManager.addAnActionListener(new AnActionListener(){

            public void beforeActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
                String id = ActionMacroManager.this.myActionManager.getId(action2);
                if (id == null) {
                    return;
                }
                if ("StartStopMacroRecording".equals(id)) {
                    ActionMacroManager.this.myLastActionInputEvent.add(event.getInputEvent());
                } else if (ActionMacroManager.this.myIsRecording) {
                    ActionMacroManager.this.myRecordingMacro.appendAction(id);
                    String shortcut = null;
                    if (event.getInputEvent() instanceof KeyEvent) {
                        shortcut = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent((KeyEvent)event.getInputEvent()));
                    }
                    ActionMacroManager.this.notifyUser(id + (shortcut != null ? " (" + shortcut + ")" : ""), false);
                    ActionMacroManager.this.myLastActionInputEvent.add(event.getInputEvent());
                }
            }

            public void beforeEditorTyping(char c2, DataContext dataContext) {
            }

            public void afterActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
            }
        });
        this.myKeyProcessor = new MyKeyPostpocessor();
        IdeEventQueue.getInstance().addPostprocessor(this.myKeyProcessor, null);
    }

    public void loadState(Element state) {
        this.myMacros = new ArrayList();
        for (Element macroElement : state.getChildren(ELEMENT_MACRO)) {
            ActionMacro macro2 = new ActionMacro();
            macro2.readExternal(macroElement);
            this.myMacros.add(macro2);
        }
        this.registerActions();
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        for (ActionMacro macro2 : this.myMacros) {
            Element macroElement = new Element(ELEMENT_MACRO);
            macro2.writeExternal(macroElement);
            element.addContent(macroElement);
        }
        return element;
    }

    public static ActionMacroManager getInstance() {
        return (ActionMacroManager)ApplicationManager.getApplication().getComponent(ActionMacroManager.class);
    }

    public void startRecording(String macroName) {
        LOG.assertTrue(!this.myIsRecording);
        this.myIsRecording = true;
        this.myRecordingMacro = new ActionMacro(macroName);
        StatusBar statusBar = WindowManager.getInstance().getIdeFrame(null).getStatusBar();
        this.myWidget = new Widget(statusBar);
        statusBar.addWidget((StatusBarWidget)this.myWidget);
    }

    public void stopRecording(@Nullable Project project2) {
        String macroName;
        LOG.assertTrue(this.myIsRecording);
        if (this.myWidget != null) {
            this.myWidget.delete();
            this.myWidget = null;
        }
        this.myIsRecording = false;
        this.myLastActionInputEvent.clear();
        do {
            if ((macroName = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.enter.macro.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.enter.macro.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                this.myRecordingMacro = null;
                return;
            }
            if (!macroName.isEmpty()) continue;
            macroName = null;
        } while (macroName != null && !this.checkCanCreateMacro(macroName));
        this.myLastMacro = this.myRecordingMacro;
        this.addRecordedMacroWithName(macroName);
        this.registerActions();
    }

    private void addRecordedMacroWithName(@Nullable String macroName) {
        if (macroName != null) {
            this.myRecordingMacro.setName(macroName);
            this.myMacros.add(this.myRecordingMacro);
            this.myRecordingMacro = null;
        } else {
            for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
                ActionMacro macro2 = this.myMacros.get(i2);
                if (!IdeBundle.message((String)"macro.noname", (Object[])new Object[0]).equals(macro2.getName())) continue;
                this.myMacros.set(i2, this.myRecordingMacro);
                this.myRecordingMacro = null;
                break;
            }
            if (this.myRecordingMacro != null) {
                this.myMacros.add(this.myRecordingMacro);
                this.myRecordingMacro = null;
            }
        }
    }

    public void playbackLastMacro() {
        if (this.myLastMacro != null) {
            this.playbackMacro(this.myLastMacro);
        }
    }

    private void playbackMacro(ActionMacro macro2) {
        ActionMacro.ActionDescriptor[] actions2;
        final IdeFrame frame = WindowManager.getInstance().getIdeFrame(null);
        assert (frame != null);
        StringBuffer script = new StringBuffer();
        for (ActionMacro.ActionDescriptor each : actions2 = macro2.getActions()) {
            each.generateTo(script);
        }
        PlaybackRunner runner = new PlaybackRunner(script.toString(), new PlaybackRunner.StatusCallback.Edt(){

            @Override
            public void messageEdt(PlaybackContext context2, String text2, PlaybackRunner.StatusCallback.Type type) {
                StatusBar statusBar;
                if ((type == PlaybackRunner.StatusCallback.Type.message || type == PlaybackRunner.StatusCallback.Type.error) && (statusBar = frame.getStatusBar()) != null) {
                    if (context2 != null) {
                        text2 = "Line " + context2.getCurrentLine() + ": " + text2;
                    }
                    statusBar.setInfo(text2);
                }
            }
        }, Registry.is((String)"actionSystem.playback.useDirectActionCall"), true, Registry.is((String)"actionSystem.playback.useTypingTargets"));
        this.myIsPlaying = true;
        runner.run().doWhenDone(() -> {
            StatusBar statusBar = frame.getStatusBar();
            statusBar.setInfo("Script execution finished");
        }).doWhenProcessed(() -> {
            this.myIsPlaying = false;
        });
    }

    public boolean isRecording() {
        return this.myIsRecording;
    }

    public void dispose() {
        IdeEventQueue.getInstance().removePostprocessor(this.myKeyProcessor);
    }

    public ActionMacro[] getAllMacros() {
        return this.myMacros.toArray(new ActionMacro[this.myMacros.size()]);
    }

    public void removeAllMacros() {
        if (this.myLastMacro != null) {
            this.myLastMacroName = this.myLastMacro.getName();
            this.myLastMacro = null;
        }
        this.myMacros = new ArrayList();
    }

    public void addMacro(ActionMacro macro2) {
        this.myMacros.add(macro2);
        if (this.myLastMacroName != null && this.myLastMacroName.equals(macro2.getName())) {
            this.myLastMacro = macro2;
            this.myLastMacroName = null;
        }
    }

    public void playMacro(ActionMacro macro2) {
        this.playbackMacro(macro2);
        this.myLastMacro = macro2;
    }

    public boolean hasRecentMacro() {
        return this.myLastMacro != null;
    }

    public void registerActions() {
        ActionMacro[] macros;
        this.unregisterActions();
        HashSet<String> registeredIds = new HashSet<String>();
        for (ActionMacro macro2 : macros = this.getAllMacros()) {
            String actionId = macro2.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            this.myActionManager.registerAction(actionId, (AnAction)new InvokeMacroAction(macro2));
        }
    }

    public void unregisterActions() {
        String[] oldIds;
        for (String oldId : oldIds = this.myActionManager.getActionIds("Macro.")) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public boolean checkCanCreateMacro(String name) {
        String actionId;
        ActionManagerEx actionManager = (ActionManagerEx)ActionManager.getInstance();
        if (actionManager.getAction(actionId = "Macro." + name) != null) {
            if (Messages.showYesNoDialog((String)IdeBundle.message((String)"message.macro.exists", (Object[])new Object[]{name}), (String)IdeBundle.message((String)"title.macro.name.already.used", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            actionManager.unregisterAction(actionId);
            this.removeMacro(name);
        }
        return true;
    }

    private void removeMacro(String name) {
        for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
            ActionMacro macro2 = this.myMacros.get(i2);
            if (!name.equals(macro2.getName())) continue;
            this.myMacros.remove(i2);
            break;
        }
    }

    public boolean isPlaying() {
        return this.myIsPlaying;
    }

    private void notifyUser(String text2, boolean typing) {
        String actualText = text2;
        if (typing) {
            int maxLength = TYPING_SAMPLE.length();
            this.myLastTyping = this.myLastTyping + text2;
            if (this.myLastTyping.length() > maxLength) {
                this.myLastTyping = "..." + this.myLastTyping.substring(this.myLastTyping.length() - maxLength);
            }
            actualText = this.myLastTyping;
        } else {
            this.myLastTyping = "";
        }
        if (this.myWidget != null) {
            this.myWidget.notifyUser(RECORDED + actualText);
        }
    }

    private class MyKeyPostpocessor
    implements IdeEventQueue.EventDispatcher {
        private MyKeyPostpocessor() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actionMacro/ActionMacroManager$MyKeyPostpocessor", "dispatch"));
            }
            if (ActionMacroManager.this.isRecording() && e2 instanceof KeyEvent) {
                this.postProcessKeyEvent((KeyEvent)e2);
            }
            return false;
        }

        public void postProcessKeyEvent(KeyEvent e2) {
            boolean isEnter;
            boolean modifierKeyIsPressed;
            if (e2.getID() != 401) {
                return;
            }
            if (ActionMacroManager.this.myLastActionInputEvent.contains(e2)) {
                ActionMacroManager.this.myLastActionInputEvent.remove(e2);
                return;
            }
            boolean bl = modifierKeyIsPressed = e2.getKeyCode() == 17 || e2.getKeyCode() == 18 || e2.getKeyCode() == 157 || e2.getKeyCode() == 16;
            if (modifierKeyIsPressed) {
                return;
            }
            boolean ready = IdeEventQueue.getInstance().getKeyEventDispatcher().isReady();
            boolean isChar = e2.getKeyChar() != '\uffff' && UIUtil.isReallyTypedEvent((KeyEvent)e2);
            boolean hasActionModifiers = e2.isAltDown() | e2.isControlDown() | e2.isMetaDown();
            boolean plainType = isChar && !hasActionModifiers;
            boolean bl2 = isEnter = e2.getKeyCode() == 10;
            if (plainType && ready && !isEnter) {
                ActionMacroManager.this.myRecordingMacro.appendKeytyped(e2.getKeyChar(), e2.getKeyCode(), e2.getModifiers());
                ActionMacroManager.this.notifyUser(Character.valueOf(e2.getKeyChar()).toString(), true);
            } else if (!plainType && ready || isEnter) {
                String stroke = KeyStroke.getKeyStrokeForEvent(e2).toString();
                int pressed = stroke.indexOf("pressed");
                String key = stroke.substring(pressed + "pressed".length());
                String modifiers = stroke.substring(0, pressed);
                String shortcut = (modifiers.replaceAll("ctrl", "control").trim() + " " + key.trim()).trim();
                ActionMacroManager.this.myRecordingMacro.appendShortcut(shortcut);
                ActionMacroManager.this.notifyUser(KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent(e2)), false);
            }
        }
    }

    private static class InvokeMacroAction
    extends AnAction {
        private final ActionMacro myMacro;

        InvokeMacroAction(ActionMacro macro2) {
            this.myMacro = macro2;
            this.getTemplatePresentation().setText(macro2.getName(), false);
        }

        public void actionPerformed(AnActionEvent e2) {
            IdeEventQueue.getInstance().doWhenReady(() -> ActionMacroManager.getInstance().playMacro(this.myMacro));
        }

        public void update(AnActionEvent e2) {
            super.update(e2);
            e2.getPresentation().setEnabled(!ActionMacroManager.getInstance().isPlaying());
        }
    }

    private class Widget
    implements CustomStatusBarWidget,
    Consumer<MouseEvent> {
        private AnimatedIcon myIcon = new AnimatedIcon("Macro recording", new Icon[]{AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4}, AllIcons.Ide.Macro.Recording_1, 1000);
        private StatusBar myStatusBar;
        private final StatusBarWidget.WidgetPresentation myPresentation;
        private JPanel myBalloonComponent;
        private Balloon myBalloon;
        private final JLabel myText;

        private Widget(StatusBar statusBar) {
            this.myStatusBar = statusBar;
            this.myPresentation = new StatusBarWidget.WidgetPresentation(){

                public String getTooltipText() {
                    return "Macro is being recorded now";
                }

                public Consumer<MouseEvent> getClickConsumer() {
                    return Widget.this;
                }
            };
            new BaseButtonBehavior((JComponent)this.myIcon){

                protected void execute(MouseEvent e2) {
                    Widget.this.showBalloon();
                }
            };
            this.myBalloonComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
            AnAction stopAction = ActionManager.getInstance().getAction("StartStopMacroRecording");
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(stopAction);
            ActionToolbar tb2 = ActionManager.getInstance().createActionToolbar("StatusBarPlace", (ActionGroup)group, true);
            tb2.setMiniMode(true);
            NonOpaquePanel top = new NonOpaquePanel((LayoutManager)new BorderLayout());
            top.add((Component)tb2.getComponent(), (Object)"West");
            this.myText = new JLabel("Recorded: ...WWWWWWWWWWWWWWWWWWWW", 2);
            Dimension preferredSize = this.myText.getPreferredSize();
            this.myText.setPreferredSize(preferredSize);
            this.myText.setText("Macro recording started...");
            ActionMacroManager.this.myLastTyping = "";
            top.add((Component)this.myText, (Object)"Center");
            this.myBalloonComponent.add((Component)top, "Center");
        }

        private void showBalloon() {
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)this.myBalloonComponent).setAnimationCycle(200).setCloseButtonEnabled(true).setHideOnAction(false).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setSmallVariant(true).setShadow(true).createBalloon();
            Disposer.register((Disposable)this.myBalloon, (Disposable)new Disposable(){

                public void dispose() {
                    Widget.this.myBalloon = null;
                }
            });
            this.myBalloon.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (Widget.this.myBalloon != null) {
                        Disposer.dispose((Disposable)Widget.this.myBalloon);
                    }
                }
            });
            this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myIcon){

                public RelativePoint recalculateLocation(Balloon object) {
                    return new RelativePoint((Component)Widget.this.myIcon, new Point(((Widget)Widget.this).myIcon.getSize().width / 2, 4));
                }
            }, Balloon.Position.above);
        }

        public JComponent getComponent() {
            return this.myIcon;
        }

        @NotNull
        public String ID() {
            if ("MacroRecording" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actionMacro/ActionMacroManager$Widget", "ID"));
            }
            return "MacroRecording";
        }

        public void consume(MouseEvent mouseEvent) {
        }

        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/actionMacro/ActionMacroManager$Widget", "getPresentation"));
            }
            return this.myPresentation;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/ide/actionMacro/ActionMacroManager$Widget", "install"));
            }
            this.showBalloon();
        }

        public void dispose() {
            this.myIcon.dispose();
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
            }
        }

        public void delete() {
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
            }
            this.myStatusBar.removeWidget(this.ID());
        }

        public void notifyUser(String text2) {
            this.myText.setText(text2);
            this.myText.revalidate();
            this.myText.repaint();
        }
    }
}

