/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.OpenModuleSettingsAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNavigateToSourceAction
extends AnAction
implements DumbAware {
    private final boolean myFocusEditor;

    protected BaseNavigateToSourceAction(boolean focusEditor) {
        this.myFocusEditor = focusEditor;
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        OpenSourceUtil.navigate((boolean)this.myFocusEditor, (Navigatable[])this.getNavigatables(dataContext));
    }

    public void update(AnActionEvent e2) {
        boolean enabled;
        boolean inPopup = ActionPlaces.isPopupPlace((String)e2.getPlace());
        Navigatable target = this.findTargetForUpdate(e2.getDataContext());
        boolean bl = enabled = target != null;
        if (inPopup && !(this instanceof OpenModuleSettingsAction) && OpenModuleSettingsAction.isModuleInProjectViewPopup(e2)) {
            e2.getPresentation().setVisible(false);
            return;
        }
        e2.getPresentation().setVisible(!(!enabled && inPopup || !this.myFocusEditor && target instanceof NavigatableWithText));
        e2.getPresentation().setEnabled(enabled);
        String navigateActionText = this.myFocusEditor && target instanceof NavigatableWithText ? ((NavigatableWithText)target).getNavigateActionText(true) : null;
        e2.getPresentation().setText(navigateActionText == null ? this.getTemplatePresentation().getText() : navigateActionText);
    }

    @Nullable
    private Navigatable findTargetForUpdate(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/BaseNavigateToSourceAction", "findTargetForUpdate"));
        }
        Navigatable[] navigatables = this.getNavigatables(dataContext);
        if (navigatables == null) {
            return null;
        }
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            return navigatable instanceof PomTargetPsiElement ? ((PomTargetPsiElement)navigatable).getTarget() : navigatable;
        }
        return null;
    }

    @Nullable
    protected Navigatable[] getNavigatables(DataContext dataContext) {
        return (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
    }
}

