/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseAllEditorsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            VirtualFile[] openFiles;
            EditorWindow window = (EditorWindow)e2.getData(EditorWindow.DATA_KEY);
            if (window != null) {
                VirtualFile[] files2;
                for (VirtualFile file2 : files2 = window.getFiles()) {
                    window.closeFile(file2);
                }
                return;
            }
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
            VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
            for (VirtualFile openFile2 : openFiles = fileEditorManager.getSiblings(selectedFile)) {
                fileEditorManager.closeFile(openFile2);
            }
        }, IdeBundle.message((String)"command.close.all.editors", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        EditorWindow editorWindow = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (editorWindow != null && editorWindow.inSplitter()) {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors.in.tab.group", (Object[])new Object[0]));
        } else {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors", (Object[])new Object[0]));
        }
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(FileEditorManager.getInstance((Project)project2).getSelectedFiles().length > 0);
    }
}

