/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseEditorAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx editorManager = CloseEditorAction.getEditorManager(project2);
        EditorWindow window = (EditorWindow)e2.getData(EditorWindow.DATA_KEY);
        VirtualFile file2 = null;
        if (window == null) {
            window = editorManager.getCurrentWindow();
            if (window != null) {
                file2 = window.getSelectedFile();
            }
        } else {
            file2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (file2 != null) {
            editorManager.closeFile(file2, window);
        }
    }

    private static FileEditorManagerEx getEditorManager(Project project2) {
        return (FileEditorManagerEx)FileEditorManager.getInstance((Project)project2);
    }

    public void update(AnActionEvent event) {
        EditorWindow window;
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        if ("EditorPopup".equals(event.getPlace()) || "EditorTabPopup".equals(event.getPlace())) {
            presentation.setText(IdeBundle.message((String)"action.close", (Object[])new Object[0]));
        }
        if ((window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null) {
            window = CloseEditorAction.getEditorManager(project2).getCurrentWindow();
        }
        presentation.setEnabled(window != null && window.getTabCount() > 0);
    }
}

