/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;

public class CopyAction
extends AnAction
implements DumbAware {
    public CopyAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        CopyProvider provider = (CopyProvider)PlatformDataKeys.COPY_PROVIDER.getData(dataContext);
        if (provider == null) {
            return;
        }
        provider.performCopy(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CopyProvider provider = (CopyProvider)PlatformDataKeys.COPY_PROVIDER.getData(dataContext);
        presentation.setEnabled(provider != null && provider.isCopyEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider != null) {
            presentation.setVisible(provider.isCopyVisible(dataContext));
        } else {
            presentation.setVisible(true);
        }
    }
}

