/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryOrPackageHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class CreateDirectoryOrPackageAction
extends AnAction
implements DumbAware {
    public CreateDirectoryOrPackageAction() {
        super(IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e2) {
        IdeView view2 = (IdeView)e2.getData(LangDataKeys.IDE_VIEW);
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (view2 == null || project2 == null) {
            return;
        }
        PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view2);
        if (directory == null) {
            return;
        }
        boolean isDirectory = !PsiDirectoryFactory.getInstance(project2).isPackage(directory);
        CreateDirectoryOrPackageHandler validator = new CreateDirectoryOrPackageHandler(project2, directory, isDirectory, isDirectory ? "\\/" : ".");
        Messages.showInputDialog((Project)project2, (String)(isDirectory ? IdeBundle.message((String)"prompt.enter.new.directory.name", (Object[])new Object[0]) : IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0])), (String)(isDirectory ? IdeBundle.message((String)"title.new.directory", (Object[])new Object[0]) : IdeBundle.message((String)"title.new.package", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiFileSystemItem result2 = validator.getCreatedElement();
        if (result2 != null) {
            view2.selectElement((PsiElement)result2);
        }
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        IdeView view2 = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        if (view2 == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        PsiDirectory[] directories = view2.getDirectories();
        if (directories.length == 0) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
        boolean isPackage = false;
        PsiDirectoryFactory factory2 = PsiDirectoryFactory.getInstance(project2);
        for (PsiDirectory directory : directories) {
            if (!factory2.isPackage(directory)) continue;
            isPackage = true;
            break;
        }
        if (isPackage) {
            presentation.setText(IdeBundle.message((String)"action.package", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        } else {
            presentation.setText(IdeBundle.message((String)"action.directory", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
        }
    }
}

