/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFromTemplateDialog
extends DialogWrapper {
    private JTextField myNameField;
    private TemplateKindCombo myKindCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private JLabel myKindLabel;
    private JLabel myNameLabel;
    private ElementCreator myCreator;
    private InputValidator myInputValidator;

    protected CreateFileFromTemplateDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/CreateFileFromTemplateDialog", "<init>"));
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myKindLabel.setLabelFor((Component)((Object)this.myKindCombo));
        this.myKindCombo.registerUpDownHint(this.myNameField);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.setTemplateKindComponentsVisible(false);
        this.init();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String text2;
        boolean canClose;
        if (this.myInputValidator != null && !(canClose = this.myInputValidator.canClose(text2 = this.myNameField.getText().trim()))) {
            String message2;
            String errorText = LangBundle.message("incorrect.name", new Object[0]);
            if (this.myInputValidator instanceof InputValidatorEx && (message2 = ((InputValidatorEx)this.myInputValidator).getErrorText(text2)) != null) {
                errorText = message2;
            }
            return new ValidationInfo(errorText, (JComponent)this.myNameField);
        }
        return super.doValidate();
    }

    protected JTextField getNameField() {
        return this.myNameField;
    }

    protected TemplateKindCombo getKindCombo() {
        return this.myKindCombo;
    }

    protected JLabel getKindLabel() {
        return this.myKindLabel;
    }

    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    private String getEnteredName() {
        JTextField nameField = this.getNameField();
        String text2 = nameField.getText().trim();
        nameField.setText(text2);
        return text2;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.myCreator != null && this.myCreator.tryCreate(this.getEnteredName()).length == 0) {
            return;
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameField();
    }

    public void setTemplateKindComponentsVisible(boolean flag) {
        this.myKindCombo.setVisible(flag);
        this.myKindLabel.setVisible(flag);
        this.myUpDownHint.setVisible(flag);
    }

    public static Builder createDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/CreateFileFromTemplateDialog", "createDialog"));
        }
        CreateFileFromTemplateDialog dialog2 = new CreateFileFromTemplateDialog(project2);
        return new BuilderImpl(dialog2, project2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TemplateKindCombo templateKindCombo;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKindLabel = jLabel2 = new JLabel();
        jLabel2.setText("Kind:");
        jLabel2.setDisplayedMnemonic('K');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the kind");
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKindCombo = templateKindCombo = new TemplateKindCombo();
        jPanel.add((Component)((Object)templateKindCombo), new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface FileCreator<T> {
        @Nullable
        public T createFile(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String getActionName(@NotNull String var1, @NotNull String var2);

        public boolean startInWriteAction();
    }

    public static interface Builder {
        public Builder setTitle(String var1);

        public Builder setValidator(InputValidator var1);

        public Builder addKind(@NotNull String var1, @Nullable Icon var2, @NotNull String var3);

        @Nullable
        public <T extends PsiElement> T show(@NotNull String var1, @Nullable String var2, @NotNull FileCreator<T> var3);

        @Nullable
        public Map<String, String> getCustomProperties();
    }

    private static class BuilderImpl
    implements Builder {
        private final CreateFileFromTemplateDialog myDialog;
        private final Project myProject;

        public BuilderImpl(CreateFileFromTemplateDialog dialog2, Project project2) {
            this.myDialog = dialog2;
            this.myProject = project2;
        }

        @Override
        public Builder setTitle(String title) {
            this.myDialog.setTitle(title);
            return this;
        }

        @Override
        public Builder addKind(@NotNull String name, @Nullable Icon icon, @NotNull String templateName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl", "addKind"));
            }
            if (templateName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl", "addKind"));
            }
            this.myDialog.getKindCombo().addItem(name, icon, templateName);
            if (this.myDialog.getKindCombo().getComboBox().getItemCount() > 1) {
                this.myDialog.setTemplateKindComponentsVisible(true);
            }
            return this;
        }

        @Override
        public Builder setValidator(InputValidator validator) {
            this.myDialog.myInputValidator = validator;
            return this;
        }

        @Override
        public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedTemplateName, final @NotNull FileCreator<T> creator) {
            if (errorTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTitle", "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl", "show"));
            }
            if (creator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/ide/actions/CreateFileFromTemplateDialog$BuilderImpl", "show"));
            }
            final Ref created = Ref.create(null);
            this.myDialog.getKindCombo().setSelectedName(selectedTemplateName);
            this.myDialog.myCreator = new ElementCreator(this.myProject, errorTitle){

                protected PsiElement[] create(String newName) throws Exception {
                    PsiElement element = (PsiElement)creator.createFile(myDialog.getEnteredName(), myDialog.getKindCombo().getSelectedName());
                    created.set((Object)element);
                    if (element != null) {
                        return new PsiElement[]{element};
                    }
                    return PsiElement.EMPTY_ARRAY;
                }

                public boolean startInWriteAction() {
                    return creator.startInWriteAction();
                }

                protected String getActionName(String newName) {
                    return creator.getActionName(newName, myDialog.getKindCombo().getSelectedName());
                }
            };
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                return (T)((PsiElement)created.get());
            }
            return null;
        }

        @Override
        @Nullable
        public Map<String, String> getCustomProperties() {
            return null;
        }
    }
}

