/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CutProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;

public class CutAction
extends AnAction
implements DumbAware {
    public CutAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e2) {
        CutProvider provider = CutAction.getAvailableCutProvider(e2);
        if (provider == null) {
            return;
        }
        provider.performCut(e2.getDataContext());
    }

    private static CutProvider getAvailableCutProvider(AnActionEvent e2) {
        CutProvider provider = (CutProvider)PlatformDataKeys.CUT_PROVIDER.getData(e2.getDataContext());
        Project project2 = e2.getProject();
        if (project2 != null && DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)provider)) {
            return null;
        }
        return provider;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CutProvider provider = CutAction.getAvailableCutProvider(event);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(project2 != null && project2.isOpen() && provider != null && provider.isCutEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider != null) {
            presentation.setVisible(provider.isCutVisible(dataContext));
        } else {
            presentation.setVisible(true);
        }
    }
}

