/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludingActionGroup
extends ActionGroup {
    private final ActionGroup myDelegate;
    private final Set<AnAction> myExcludes;

    public ExcludingActionGroup(ActionGroup delegate2, Set<AnAction> excludes) {
        super(delegate2.getTemplatePresentation().getText(), delegate2.isPopup());
        this.myDelegate = delegate2;
        this.myExcludes = excludes;
    }

    public void update(AnActionEvent e2) {
        this.myDelegate.update(e2);
    }

    public boolean isDumbAware() {
        return this.myDelegate.isDumbAware();
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        ArrayList<ExcludingActionGroup> result2 = new ArrayList<ExcludingActionGroup>();
        for (AnAction action2 : this.myDelegate.getChildren(e2)) {
            if (this.myExcludes.contains(action2)) continue;
            if (action2 instanceof ActionGroup) {
                result2.add(new ExcludingActionGroup((ActionGroup)action2, this.myExcludes));
                continue;
            }
            result2.add((ExcludingActionGroup)action2);
        }
        AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExcludingActionGroup", "getChildren"));
        }
        return anActionArray;
    }
}

