/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HeldDownKeyListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(final @NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionAction", "gotoActionPerformed"));
        }
        final Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        final Component component = (Component)e2.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model2 = new GotoActionModel(project2, component, editor, file2);
        GotoActionBase.GotoActionCallback<Object> callback = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(@NotNull ChooseByNamePopup popup2, @NotNull Object element) {
                if (popup2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                if (project2 != null) {
                    project2.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                }
                String enteredText = popup2.getTrimmedText();
                GotoActionAction.openOptionOrPerformAction(((GotoActionModel.MatchedValue)element).value, enteredText, project2, component, e2);
            }
        };
        Pair<String, Integer> start2 = GotoActionAction.getInitialText(false, e2);
        this.showNavigationPopup(callback, null, GotoActionAction.createPopup(project2, model2, (String)start2.first, (Integer)start2.second, component, e2), false);
    }

    @Nullable
    private static ChooseByNamePopup createPopup(@Nullable Project project2, final @NotNull GotoActionModel model2, String initialText, int initialIndex, final Component component, final AnActionEvent e2) {
        ChooseByNamePopup oldPopup;
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/actions/GotoActionAction", "createPopup"));
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project2 == null ? null : (ChooseByNamePopup)project2.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        final Disposable disposable = Disposer.newDisposable();
        final ChooseByNamePopup popup2 = new ChooseByNamePopup(project2, model2, new GotoActionItemProvider(model2), oldPopup, initialText, false, initialIndex){
            private boolean myPaintInternalInfo;

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                this.myList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e2) {
                        Object value2 = myList.getSelectedValue();
                        String text2 = this.getText(value2);
                        if (text2 != null && myDropdownPopup != null) {
                            myDropdownPopup.setAdText(text2, 2);
                        }
                        String description = this.getValueDescription(value2);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }

                    @Nullable
                    private String getText(@Nullable Object o2) {
                        if (o2 instanceof GotoActionModel.MatchedValue) {
                            GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)o2;
                            if (myPaintInternalInfo && mv.value instanceof GotoActionModel.ActionWrapper) {
                                AnAction action2 = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                                String actionId = ActionManager.getInstance().getId(action2);
                                return StringUtil.notNullize((String)actionId, (String)("class: " + actionId.getClass().getName()));
                            }
                            if (mv.value instanceof BooleanOptionDescription || mv.value instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)mv.value).getAction() instanceof ToggleAction) {
                                return "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0)) + " to toggle option";
                            }
                        }
                        return this.getAdText();
                    }
                });
                this.myList.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e2) {
                        int index = myList.locationToIndex(e2.getPoint());
                        if (index == -1) {
                            return;
                        }
                        Object value2 = myList.getModel().getElementAt(index);
                        String description = this.getValueDescription(value2);
                        ActionMenu.showDescriptionInStatusBar(true, myList, description);
                    }
                });
                if (Registry.is((String)"show.configurables.ids.in.settings")) {
                    new HeldDownKeyListener(){

                        protected void heldKeyTriggered(JComponent component, boolean pressed) {
                            myPaintInternalInfo = pressed;
                            ListSelectionEvent event = new ListSelectionEvent((Object)this, -1, -1, false);
                            for (ListSelectionListener listener2 : myList.getListSelectionListeners()) {
                                listener2.valueChanged(event);
                            }
                        }
                    }.installOn((JComponent)this.myTextField);
                }
            }

            @Nullable
            private String getValueDescription(@Nullable Object value2) {
                if (value2 instanceof GotoActionModel.MatchedValue) {
                    GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)value2;
                    if (mv.value instanceof GotoActionModel.ActionWrapper) {
                        AnAction action2 = ((GotoActionModel.ActionWrapper)mv.value).getAction();
                        return action2.getTemplatePresentation().getDescription();
                    }
                }
                return null;
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                Set<Object> set2 = super.filter(model2.sortItems(elements));
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                return set2;
            }

            @Override
            protected boolean closeForbidden(boolean ok) {
                if (!ok) {
                    return false;
                }
                Object element = this.getChosenElement();
                return element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, this, component, e2) || super.closeForbidden(true);
            }

            @Override
            public void setDisposed(boolean disposedFlag) {
                super.setDisposed(disposedFlag);
                Disposer.dispose((Disposable)disposable);
                ActionMenu.showDescriptionInStatusBar(true, this.myList, null);
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    this.myList.removeListSelectionListener(listener2);
                }
                UIUtil.dispose((Component)this.myList);
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(ProgressWindow.TOPIC, (Object)new ProgressWindow.Listener(){

            @Override
            public void progressWindowCreated(ProgressWindow pw) {
                Disposer.register((Disposable)pw, (Disposable)new Disposable(){

                    public void dispose() {
                        if (!popup2.checkDisposed()) {
                            popup2.repaintList();
                        }
                    }
                });
            }
        });
        if (project2 != null) {
            project2.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup2);
        }
        popup2.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent me) {
                if (me == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ide/actions/GotoActionAction$4", "mouseClicked"));
                }
                Object element = popup2.getSelectionByPoint(me.getPoint());
                if (element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, popup2, component, e2)) {
                    me.consume();
                }
            }
        });
        CustomShortcutSet shortcutSet = new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ShowIntentionActions"));
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e2) {
                GotoActionModel.ActionWrapper aw;
                boolean available;
                Comparable value2;
                Object o2 = popup2.getChosenElement();
                if (o2 instanceof GotoActionModel.MatchedValue && (value2 = ((GotoActionModel.MatchedValue)o2).value) instanceof GotoActionModel.ActionWrapper && (available = (aw = (GotoActionModel.ActionWrapper)value2).isAvailable())) {
                    AnAction action2 = aw.getAction();
                    String id = ActionManager.getInstance().getId(action2);
                    KeymapManagerImpl km = (KeymapManagerImpl)KeymapManager.getInstance();
                    Keymap k2 = km.getActiveKeymap();
                    if (!k2.canModify()) {
                        return;
                    }
                    KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), k2, component, new QuickList[0]);
                    popup2.repaintListImmediate();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)popup2.getTextField(), disposable);
        return popup2;
    }

    private static boolean processOptionInplace(Object value2, ChooseByNamePopup popup2, Component component, AnActionEvent e2) {
        AnAction action2;
        if (value2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value2).isOptionEnabled());
            GotoActionAction.repaint(popup2);
            return true;
        }
        if (value2 instanceof GotoActionModel.ActionWrapper && (action2 = ((GotoActionModel.ActionWrapper)value2).getAction()) instanceof ToggleAction) {
            GotoActionAction.performAction(action2, component, e2, () -> GotoActionAction.repaint(popup2));
            return true;
        }
        return false;
    }

    private static void repaint(@Nullable ChooseByNamePopup popup2) {
        if (popup2 != null) {
            popup2.repaintListImmediate();
        }
    }

    public static void openOptionOrPerformAction(@NotNull Object element, String enteredText, @Nullable Project project2, Component component, @Nullable AnActionEvent e2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction", "openOptionOrPerformAction"));
        }
        if (element instanceof OptionDescription) {
            String configurableId = ((OptionDescription)element).getConfigurableId();
            TransactionGuard.getInstance().submitTransactionLater((Disposable)(project2 != null ? project2 : ApplicationManager.getApplication()), () -> ShowSettingsUtilImpl.showSettingsDialog(project2, configurableId, enteredText));
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction", "lambda$openOptionOrPerformAction$3"));
                }
                IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction", "lambda$null$2"));
                    }
                    GotoActionAction.performAction(element, component, e2);
                });
            });
        }
    }

    public static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e2) {
        GotoActionAction.performAction(element, component, e2, null);
    }

    public static void performAction(Object element, @Nullable Component component, @Nullable AnActionEvent e2, @Nullable Runnable callback) {
        if (component == null) {
            return;
        }
        AnAction action2 = element instanceof AnAction ? (AnAction)element : ((GotoActionModel.ActionWrapper)element).getAction();
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            DataManager instance2;
            DataContext context2;
            InputEvent inputEvent = e2 == null ? null : e2.getInputEvent();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)(context2 = (instance2 = DataManager.getInstance()) != null ? instance2.getDataContext(component) : DataContext.EMPTY_CONTEXT));
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
                if (action2 instanceof ActionGroup && ((ActionGroup)action2).getChildren(event).length > 0) {
                    ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action2, context2, false, callback, -1);
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window != null) {
                        popup2.showInCenterOf((Component)window);
                    } else {
                        popup2.showInFocusCenter();
                    }
                } else {
                    ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        });
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }
}

