/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.GotoActionBase");
    protected static Class myInAction = null;
    private static final Map<Class, Pair<String, Integer>> ourLastStrings = ContainerUtil.newHashMap();
    private static final Map<Class, List<String>> ourHistory = ContainerUtil.newHashMap();
    private int myHistoryIndex = 0;

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase", "actionPerformed"));
        }
        LOG.assertTrue(!((Object)((Object)this)).getClass().equals(myInAction));
        try {
            myInAction = ((Object)((Object)this)).getClass();
            List<String> strings = ourHistory.get(myInAction);
            this.myHistoryIndex = strings == null || strings.size() <= 1 || !ourLastStrings.containsKey(myInAction) ? 0 : 1;
            this.gotoActionPerformed(e2);
        }
        catch (ProcessCanceledException e1) {
            myInAction = null;
        }
        catch (Throwable t2) {
            LOG.error(t2);
            myInAction = null;
        }
    }

    protected abstract void gotoActionPerformed(AnActionEvent var1);

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/GotoActionBase", "update"));
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(!((Object)((Object)this)).getClass().equals(myInAction) && (!this.requiresProject() || project2 != null) && this.hasContributors(dataContext));
        presentation.setVisible(this.hasContributors(dataContext));
    }

    protected boolean hasContributors(DataContext dataContext) {
        return true;
    }

    protected boolean requiresProject() {
        return true;
    }

    @Nullable
    public static PsiElement getPsiContext(AnActionEvent e2) {
        PsiFile file2 = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null) {
            return file2;
        }
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        return GotoActionBase.getPsiContext(project2);
    }

    @Nullable
    public static PsiElement getPsiContext(Project project2) {
        if (project2 == null) {
            return null;
        }
        Editor selectedEditor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (selectedEditor == null) {
            return null;
        }
        com.intellij.openapi.editor.Document document = selectedEditor.getDocument();
        return PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
    }

    protected static Pair<String, Integer> getInitialText(boolean useEditorSelection, AnActionEvent e2) {
        Pair<String, Integer> lastString;
        SpeedSearchSupply supply;
        String selectedText;
        String predefined = (String)e2.getData(PlatformDataKeys.PREDEFINED_TEXT);
        if (!StringUtil.isEmpty((String)predefined)) {
            return Pair.create((Object)predefined, (Object)0);
        }
        if (useEditorSelection && (selectedText = GotoActionBase.getInitialTextForNavigation((Editor)e2.getData(CommonDataKeys.EDITOR))) != null) {
            return new Pair((Object)selectedText, (Object)0);
        }
        String query = (String)e2.getData(SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY);
        if (!StringUtil.isEmpty((String)query)) {
            return Pair.create((Object)query, (Object)0);
        }
        Component focusOwner = IdeFocusManager.getInstance((Project)GotoActionBase.getEventProject((AnActionEvent)e2)).getFocusOwner();
        if (focusOwner instanceof JComponent && (supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner))) != null) {
            return Pair.create((Object)supply.getEnteredPrefix(), (Object)0);
        }
        if (myInAction != null && (lastString = ourLastStrings.get(myInAction)) != null) {
            return lastString;
        }
        return Pair.create((Object)"", (Object)0);
    }

    @Nullable
    public static String getInitialTextForNavigation(@Nullable Editor editor) {
        String selectedText;
        if (editor != null && (selectedText = editor.getSelectionModel().getSelectedText()) != null && !selectedText.contains("\n")) {
            return selectedText;
        }
        return null;
    }

    protected <T> void showNavigationPopup(AnActionEvent e2, ChooseByNameModel model2, GotoActionCallback<T> callback) {
        this.showNavigationPopup(e2, model2, callback, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e2, ChooseByNameModel model2, GotoActionCallback<T> callback, boolean allowMultipleSelection) {
        this.showNavigationPopup(e2, model2, callback, null, true, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(AnActionEvent e2, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable String findUsagesTitle, boolean useSelectionFromEditor) {
        this.showNavigationPopup(e2, model2, callback, findUsagesTitle, useSelectionFromEditor, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e2, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection) {
        this.showNavigationPopup(e2, model2, callback, findUsagesTitle, useSelectionFromEditor, allowMultipleSelection, new DefaultChooseByNameItemProvider(GotoActionBase.getPsiContext(e2)));
    }

    protected <T> void showNavigationPopup(AnActionEvent e2, ChooseByNameModel model2, GotoActionCallback<T> callback, @Nullable String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection, DefaultChooseByNameItemProvider itemProvider) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        boolean mayRequestOpenInCurrentWindow = model2.willOpenEditor() && FileEditorManagerEx.getInstanceEx(project2).hasSplitOrUndockedWindows();
        Pair<String, Integer> start2 = GotoActionBase.getInitialText(useSelectionFromEditor, e2);
        this.showNavigationPopup(callback, findUsagesTitle, ChooseByNamePopup.createPopup(project2, model2, itemProvider, (String)start2.first, mayRequestOpenInCurrentWindow, (int)((Integer)start2.second)), allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(GotoActionCallback<T> callback, @Nullable String findUsagesTitle, ChooseByNamePopup popup2) {
        this.showNavigationPopup(callback, findUsagesTitle, popup2, true);
    }

    protected <T> void showNavigationPopup(final GotoActionCallback<T> callback, @Nullable String findUsagesTitle, final ChooseByNamePopup popup2, boolean allowMultipleSelection) {
        final Class startedAction = myInAction;
        LOG.assertTrue(startedAction != null);
        popup2.setCheckBoxShortcut(this.getShortcutSet());
        popup2.setFindUsagesTitle(findUsagesTitle);
        final ChooseByNameFilter<T> filter2 = callback.createFilter(popup2);
        if (GotoActionBase.historyEnabled() && popup2.getAdText() == null) {
            popup2.setAdText("Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(38, 2)) + " or " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(40, 2)) + " to navigate through the history");
        }
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (startedAction != null && startedAction.equals(myInAction)) {
                    String text2 = popup2.getEnteredText();
                    ourLastStrings.put(myInAction, Pair.create((Object)text2, (Object)popup2.getSelectedIndex()));
                    this.updateHistory(text2);
                    myInAction = null;
                }
                if (filter2 != null) {
                    filter2.close();
                }
            }

            private void updateHistory(@Nullable String text2) {
                if (!StringUtil.isEmptyOrSpaces((String)text2)) {
                    List history = (List)ourHistory.get(myInAction);
                    if (history == null) {
                        history = ContainerUtil.newArrayList();
                    }
                    if (!text2.equals(ContainerUtil.getFirstItem((List)history))) {
                        history.add(0, text2);
                    }
                    ourHistory.put(myInAction, history);
                }
            }

            public void elementChosen(Object element) {
                callback.elementChosen(popup2, element);
            }
        }, ModalityState.current(), allowMultipleSelection);
        final JTextField editor = popup2.getTextField();
        final DocumentAdapter historyResetListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                GotoActionBase.this.myHistoryIndex = 0;
            }
        };
        editor.getDocument().addDocumentListener((DocumentListener)historyResetListener);
        abstract class HistoryAction
        extends DumbAwareAction {
            final /* synthetic */ JTextField val$editor;
            final /* synthetic */ DocumentAdapter val$historyResetListener;

            HistoryAction() {
                this.val$editor = jTextField;
                this.val$historyResetListener = documentAdapter;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$1HistoryAction", "update"));
                }
                e2.getPresentation().setEnabled(GotoActionBase.historyEnabled());
            }

            void setText(@NotNull List<String> strings) {
                if (strings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/ide/actions/GotoActionBase$1HistoryAction", "setText"));
                }
                Document document = this.val$editor.getDocument();
                document.removeDocumentListener((DocumentListener)this.val$historyResetListener);
                this.val$editor.setText(strings.get(GotoActionBase.this.myHistoryIndex));
                document.addDocumentListener((DocumentListener)this.val$historyResetListener);
                this.val$editor.selectAll();
            }
        }
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$3", "actionPerformed"));
                }
                List strings = (List)ourHistory.get(myInAction);
                this.setText(strings);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex >= strings.size() - 1 ? 0 : GotoActionBase.this.myHistoryIndex + 1;
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ctrl UP"}), editor);
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$4", "actionPerformed"));
                }
                List strings = (List)ourHistory.get(myInAction);
                this.setText(strings);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex <= 0 ? strings.size() - 1 : GotoActionBase.this.myHistoryIndex - 1;
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ctrl DOWN"}), editor);
    }

    private static boolean historyEnabled() {
        return !ContainerUtil.isEmpty((Collection)ourHistory.get(myInAction));
    }

    protected static abstract class GotoActionCallback<T> {
        protected GotoActionCallback() {
        }

        @Nullable
        protected ChooseByNameFilter<T> createFilter(@NotNull ChooseByNamePopup popup2) {
            if (popup2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionBase$GotoActionCallback", "createFilter"));
            }
            return null;
        }

        public abstract void elementChosen(ChooseByNamePopup var1, Object var2);
    }
}

