/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameLanguageFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoClassAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        if (!DumbService.getInstance((Project)project2).isDumb()) {
            super.actionPerformed(e2);
        } else {
            DumbService.getInstance((Project)project2).showDumbModeNotification(IdeBundle.message((String)"go.to.class.dumb.mode.message", (Object[])new Object[0]));
            AnAction action2 = ActionManager.getInstance().getAction("GotoFile");
            InputEvent event = ActionCommand.getInputEvent("GotoFile");
            Component component = (Component)e2.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            ActionManager.getInstance().tryToExecute(action2, event, component, e2.getPlace(), true);
        }
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoClassAction", "gotoActionPerformed"));
        }
        final Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.class");
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final GotoClassModel2 model2 = new GotoClassModel2(project2);
        this.showNavigationPopup(e2, model2, new GotoActionBase.GotoActionCallback<Language>(){

            @Override
            protected ChooseByNameFilter<Language> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoClassAction$1", "createFilter"));
                }
                return new ChooseByNameLanguageFilter(popup2, model2, GotoClassSymbolConfiguration.getInstance(project2), project2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (element instanceof PsiElement && ((PsiElement)element).isValid()) {
                        OpenFileDescriptor descriptor2;
                        OpenFileDescriptor n2;
                        PsiElement psiElement = GotoClassAction.getElement((PsiElement)element, popup2);
                        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)(psiElement = psiElement.getNavigationElement()));
                        if (file2 != null && popup2.getLinePosition() != -1 && (n2 = (descriptor2 = new OpenFileDescriptor(project2, file2, popup2.getLinePosition(), popup2.getColumnPosition())).setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested())).canNavigate()) {
                            n2.navigate(true);
                            return;
                        }
                        if (file2 != null && popup2.getMemberPattern() != null) {
                            NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
                            Navigatable member = GotoClassAction.findMember(popup2.getMemberPattern(), psiElement, file2);
                            if (member != null) {
                                member.navigate(true);
                            }
                        }
                        NavigationUtil.activateFileWithPsiElement(psiElement, !popup2.isOpenInCurrentWindowRequested());
                    } else {
                        EditSourceUtil.navigate((NavigationItem)((NavigationItem)element), (boolean)true, (boolean)popup2.isOpenInCurrentWindowRequested());
                    }
                });
            }
        }, IdeBundle.message((String)"go.to.class.toolwindow.title", (Object[])new Object[0]), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Navigatable findMember(String pattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder = factory2 == null ? null : factory2.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file2);
        if (builder == null || editors.length == 0) {
            return null;
        }
        StructureView view2 = builder.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element = GotoClassAction.findElement(view2.getTreeModel().getRoot(), psiElement, 4);
            if (element == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)pattern).build();
            int max = Integer.MIN_VALUE;
            Object target = null;
            for (TreeElement treeElement : element.getChildren()) {
                int degree;
                String presentableText;
                if (!(treeElement instanceof StructureViewTreeElement) || (presentableText = treeElement.getPresentation().getPresentableText()) == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target instanceof Navigatable ? (Navigatable)target : null;
            return navigatable;
        }
        finally {
            Disposer.dispose((Disposable)view2);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element, int hopes) {
        Object value2 = node.getValue();
        if (value2 instanceof PsiElement) {
            if (((PsiElement)value2).isEquivalentTo(element)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child : node.getChildren()) {
                    StructureViewTreeElement e2;
                    if (!(child instanceof StructureViewTreeElement) || (e2 = GotoClassAction.findElement((StructureViewTreeElement)child, element, hopes - 1)) == null) continue;
                    return e2;
                }
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement getElement(@NotNull PsiElement element, ChooseByNamePopup popup2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoClassAction", "getElement"));
        }
        String path = popup2.getPathToAnonymous();
        if (path != null) {
            String[] classes = path.split("\\$");
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (String cls : classes) {
                if (cls.isEmpty()) continue;
                try {
                    indexes.add(Integer.parseInt(cls) - 1);
                }
                catch (Exception e2) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getElement"));
                    }
                    return psiElement;
                }
            }
            PsiElement current = element;
            Iterator iterator2 = indexes.iterator();
            while (iterator2.hasNext()) {
                int index = (Integer)iterator2.next();
                PsiElement[] anonymousClasses = GotoClassAction.getAnonymousClasses(current);
                if (index >= 0 && index < anonymousClasses.length) {
                    current = anonymousClasses[index];
                    continue;
                }
                PsiElement psiElement = current;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getElement"));
                }
                return psiElement;
            }
            PsiElement psiElement = current;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getElement"));
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement[] getAnonymousClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
        }
        for (AnonymousElementProvider provider : (AnonymousElementProvider[])Extensions.getExtensions((ExtensionPointName)AnonymousElementProvider.EP_NAME)) {
            PsiElement[] elements = provider.getAnonymousElements(element);
            if (elements.length <= 0) continue;
            if (elements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
            }
            return elements;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoClassAction", "getAnonymousClasses"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected boolean hasContributors(DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }
}

