/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GotoFileAction
extends GotoActionBase
implements DumbAware {
    public static final String ID = "GotoFile";

    @Override
    public void gotoActionPerformed(AnActionEvent e2) {
        final Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file");
        final GotoFileModel gotoFileModel = new GotoFileModel(project2);
        GotoActionBase.GotoActionCallback<FileType> callback = new GotoActionBase.GotoActionCallback<FileType>(){

            @Override
            protected ChooseByNameFilter<FileType> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoFileAction$1", "createFilter"));
                }
                return new GotoFileFilter(popup2, gotoFileModel, project2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                if (element == null) {
                    return;
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Navigatable n2 = (Navigatable)element;
                if (element instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)element).getVirtualFile();
                    if (file2 == null) {
                        return;
                    }
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, file2, popup2.getLinePosition(), popup2.getColumnPosition());
                    n2 = descriptor2.setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested());
                }
                if (n2.canNavigate()) {
                    n2.navigate(true);
                }
            }
        };
        GotoFileItemProvider provider = new GotoFileItemProvider(project2, GotoFileAction.getPsiContext(e2), gotoFileModel);
        this.showNavigationPopup(e2, gotoFileModel, callback, IdeBundle.message((String)"go.to.file.toolwindow.title", (Object[])new Object[0]), true, true, provider);
    }

    static class FileTypeComparator
    implements Comparator<FileType> {
        static final Comparator<FileType> INSTANCE = new FileTypeComparator();

        FileTypeComparator() {
        }

        @Override
        public int compare(FileType o1, FileType o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == FileTypes.UNKNOWN) {
                return 1;
            }
            if (o2 == FileTypes.UNKNOWN) {
                return -1;
            }
            if (o1.isBinary() && !o2.isBinary()) {
                return 1;
            }
            if (!o1.isBinary() && o2.isBinary()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    protected static class GotoFileFilter
    extends ChooseByNameFilter<FileType> {
        GotoFileFilter(ChooseByNamePopup popup2, GotoFileModel model2, Project project2) {
            super(popup2, model2, GotoFileConfiguration.getInstance(project2), project2);
        }

        @Override
        @NotNull
        protected List<FileType> getAllFilterValues() {
            ArrayList<FileType> elements = new ArrayList<FileType>();
            ContainerUtil.addAll(elements, (Object[])FileTypeManager.getInstance().getRegisteredFileTypes());
            Collections.sort(elements, FileTypeComparator.INSTANCE);
            ArrayList<FileType> arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoFileAction$GotoFileFilter", "getAllFilterValues"));
            }
            return arrayList;
        }

        @Override
        protected String textForFilterValue(@NotNull FileType value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/actions/GotoFileAction$GotoFileFilter", "textForFilterValue"));
            }
            return value2.getName();
        }

        @Override
        protected Icon iconForFilterValue(@NotNull FileType value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/actions/GotoFileAction$GotoFileFilter", "iconForFilterValue"));
            }
            return value2.getIcon();
        }
    }
}

