/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class InvalidateCachesAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/InvalidateCachesAction", "update"));
        }
        super.update(e2);
        e2.getPresentation().setText(ApplicationManager.getApplication().isRestartCapable() ? "Invalidate Caches / Restart..." : "Invalidate Caches...");
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/InvalidateCachesAction", "actionPerformed"));
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        boolean mac = Messages.canShowMacSheetPanel();
        boolean canRestart = app.isRestartCapable();
        String[] options = new String[canRestart ? 4 : 3];
        options[0] = canRestart ? "Invalidate and &Restart" : "Invalidate and &Exit";
        options[1] = mac ? "Cancel" : "&Invalidate";
        String string2 = options[2] = mac ? "&Invalidate" : "Cancel";
        if (canRestart) {
            options[3] = "&Just Restart";
        }
        SmartList descriptions = new SmartList();
        descriptions.add("Local History");
        for (CachesInvalidator invalidater : (CachesInvalidator[])CachesInvalidator.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull((Collection)descriptions, (Object)invalidater.getDescription());
        }
        Collections.sort(descriptions);
        String warnings = "WARNING: ";
        warnings = descriptions.size() == 1 ? warnings + (String)descriptions.get(0) + " will be also cleared." : warnings + "The following items will also be cleared:\n" + StringUtil.join((Collection)descriptions, s2 -> "  " + s2, (String)"\n");
        String message2 = "The caches will be invalidated and rebuilt on the next startup.\n\n" + warnings + "\n\nWould you like to continue?\n";
        int result2 = Messages.showDialog((Project)((Project)e2.getData(CommonDataKeys.PROJECT)), (String)message2, (String)"Invalidate Caches", (String[])options, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 == -1 || result2 == (mac ? 1 : 2)) {
            return;
        }
        if (result2 == 3) {
            app.restart(true);
            return;
        }
        UsageTrigger.trigger(ApplicationManagerEx.getApplicationEx().getName() + ".caches.invalidated");
        FSRecords.invalidateCaches();
        for (CachesInvalidator invalidater : (CachesInvalidator[])CachesInvalidator.EP_NAME.getExtensions()) {
            invalidater.invalidateCaches();
        }
        if (result2 == 0) {
            app.restart(true);
        }
    }
}

