/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.NewElementAction;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;

public class NewElementToolbarAction
extends NewElementAction {
    @Override
    public void actionPerformed(AnActionEvent e2) {
        if (e2.getData(LangDataKeys.IDE_VIEW) == null) {
            Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
            PsiDirectory psiFile = ((PsiFile)e2.getData(CommonDataKeys.PSI_FILE)).getParent();
            ProjectViewImpl.getInstance(project2).selectCB(psiFile, psiFile.getVirtualFile(), true).doWhenDone(() -> this.showPopup(DataManager.getInstance().getDataContext()));
        } else {
            super.actionPerformed(e2);
        }
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        if (event.getData(LangDataKeys.IDE_VIEW) == null) {
            ToolWindow projectViewWindow;
            Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (project2 != null && psiFile != null && (projectViewWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.PROJECT_VIEW)).isVisible()) {
                event.getPresentation().setEnabled(true);
            }
        }
    }
}

