/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends AnAction
implements DumbAware {
    OccurenceNavigatorActionBase() {
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e2.getDataContext());
        if (navigator == null) {
            return;
        }
        if (!this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor2 = occurenceInfo.getNavigateable();
        if (descriptor2 != null && descriptor2.canNavigate()) {
            descriptor2.navigate(true);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project2).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}));
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        presentation.setVisible(true);
        try {
            presentation.setEnabled(this.hasOccurenceToGo(navigator));
            presentation.setText(this.getDescription(navigator));
        }
        catch (IndexNotReadyException e2) {
            presentation.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager != null) {
            Content content2 = contentManager.getSelectedContent();
            if (content2 == null) {
                return null;
            }
            JComponent component = content2.getComponent();
            return OccurenceNavigatorActionBase.findNavigator(component);
        }
        return (OccurenceNavigator)OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext);
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue2 = new LinkedList<JComponent>();
        queue2.addLast(parent);
        while (!queue2.isEmpty()) {
            JComponent component = (JComponent)queue2.removeFirst();
            if (component instanceof OccurenceNavigator) {
                return (OccurenceNavigator)component;
            }
            if (component instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue2.addLast(selectedComponent);
                continue;
            }
            if (component == null) continue;
            for (int i2 = 0; i2 < component.getComponentCount(); ++i2) {
                Component child = component.getComponent(i2);
                if (!(child instanceof JComponent)) continue;
                queue2.addLast((JComponent)child);
            }
        }
        return null;
    }

    @Nullable
    private static Component getOccurenceNavigatorFromContext(DataContext dataContext) {
        Project project2;
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window != null) {
            Component component2;
            for (Component c2 = component2 = window.getFocusOwner(); c2 != null; c2 = c2.getParent()) {
                if (!(c2 instanceof OccurenceNavigator)) continue;
                return c2;
            }
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        ToolWindowManagerEx mgr = ToolWindowManagerEx.getInstanceEx(project2);
        String id = mgr.getLastActiveToolWindowId((Condition<JComponent>)((Condition)component -> OccurenceNavigatorActionBase.findNavigator(component) != null));
        if (id == null) {
            return null;
        }
        return (Component)OccurenceNavigatorActionBase.findNavigator(mgr.getToolWindow(id).getComponent());
    }
}

