/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class OpenModuleSettingsAction
extends EditSourceAction {
    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        if (!OpenModuleSettingsAction.isModuleInProjectViewPopup(event)) {
            event.getPresentation().setEnabledAndVisible(false);
        }
    }

    protected static boolean isModuleInProjectViewPopup(AnActionEvent e2) {
        if ("ProjectViewPopup".equals(e2.getPlace())) {
            Project project2 = OpenModuleSettingsAction.getEventProject((AnActionEvent)e2);
            Module module2 = (Module)LangDataKeys.MODULE.getData(e2.getDataContext());
            if (project2 != null && module2 != null) {
                VirtualFile moduleFolder = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e2.getDataContext());
                if (moduleFolder == null) {
                    return false;
                }
                if (ProjectRootsUtil.isModuleContentRoot(moduleFolder, project2) || ProjectRootsUtil.isModuleSourceRoot(moduleFolder, project2)) {
                    return true;
                }
            }
        }
        return false;
    }
}

