/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private static final Icon ourProjectIcon = PlatformUtils.isJetBrainsProduct() ? AllIcons.Nodes.IdeaProject : IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());
    private static final boolean ourCanInspectDirs = SystemProperties.getBooleanProperty((String)"idea.chooser.lookup.for.project.dirs", (boolean)true);

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        this(chooseFiles, chooseFiles);
    }

    public OpenProjectFileChooserDescriptor(boolean chooseFiles, boolean chooseJars) {
        super(chooseFiles, true, chooseJars, chooseJars, false, false);
        this.setHideIgnored(false);
    }

    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
        return super.isFileVisible(file2, showHiddenFiles) && (file2.isDirectory() || OpenProjectFileChooserDescriptor.isProjectFile(file2));
    }

    public boolean isFileSelectable(VirtualFile file2) {
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file2) || OpenProjectFileChooserDescriptor.isProjectFile(file2);
    }

    public Icon getIcon(VirtualFile file2) {
        if (OpenProjectFileChooserDescriptor.canInspectDirectory(file2)) {
            if (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.isIdeaDirectory(file2)) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file2, (Icon)ourProjectIcon);
            }
            Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(file2);
            if (icon != null) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file2, (Icon)icon);
            }
        }
        return super.getIcon(file2);
    }

    private static boolean canInspectDirectory(VirtualFile file2) {
        VirtualFile home = VfsUtil.getUserHomeDir();
        if (home == null || VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)home, (boolean)false)) {
            return false;
        }
        return ourCanInspectDirs || VfsUtilCore.isAncestor((VirtualFile)home, (VirtualFile)file2, (boolean)true);
    }

    private static Icon getImporterIcon(VirtualFile file2) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        if (provider != null) {
            return file2.isDirectory() && provider.lookForProjectsInDirectory() ? ourProjectIcon : provider.getIcon(file2);
        }
        return null;
    }

    public static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectFile"));
        }
        return !file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isProjectDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectDirectory"));
        }
        return file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIdeaDirectory(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isIprFile(VirtualFile file2) {
        return "ipr".equalsIgnoreCase(file2.getExtension());
    }

    private static boolean isIdeaDirectory(VirtualFile file2) {
        return ProjectKt.getProjectStoreDirectory(file2) != null;
    }

    private static boolean hasImportProvider(VirtualFile file2) {
        return ProjectOpenProcessor.getImportProvider((VirtualFile)file2) != null;
    }
}

