/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends DumbAwareAction
implements Toggleable {
    public void actionPerformed(AnActionEvent e2) {
        Handler handler2 = this.getHandler(e2);
        if (handler2 == null) {
            return;
        }
        boolean selected = !handler2.isPinned;
        handler2.setPinned(selected);
        e2.getPresentation().putClientProperty("selected", (Object)selected);
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "update"));
        }
        Handler handler2 = this.getHandler(e2);
        boolean enabled = handler2 != null;
        boolean selected = enabled && handler2.isPinned;
        e2.getPresentation().setIcon(ActionPlaces.isToolbarPlace((String)e2.getPlace()) ? AllIcons.General.Pin_tab : null);
        e2.getPresentation().putClientProperty("selected", (Object)selected);
        String text2 = ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace()) || handler2 != null && !handler2.isActiveTab ? (selected ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
        e2.getPresentation().setText(text2);
        e2.getPresentation().setEnabledAndVisible(enabled);
    }

    protected Handler getHandler(@NotNull AnActionEvent e2) {
        VirtualFile selectedFile;
        Content content2;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getHandler"));
        }
        Project project2 = e2.getProject();
        EditorWindow currentWindow = (EditorWindow)e2.getData(EditorWindow.DATA_KEY);
        Content content3 = content2 = currentWindow != null ? null : this.getContentFromEvent(e2);
        if (content2 != null && content2.isPinnable()) {
            return PinActiveTabAction.createHandler(content2);
        }
        EditorWindow window = currentWindow != null ? currentWindow : (project2 != null ? FileEditorManagerEx.getInstanceEx(project2).getCurrentWindow() : null);
        VirtualFile virtualFile = selectedFile = window == null ? null : this.getFileFromEvent(e2, window);
        if (selectedFile != null) {
            return PinActiveTabAction.createHandler(window, selectedFile);
        }
        return null;
    }

    @Nullable
    protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e2, @NotNull EditorWindow window) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getFileFromEvent"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction", "getFileFromEvent"));
        }
        return PinActiveTabAction.getFileInWindow(e2, window);
    }

    @Nullable
    protected Content getContentFromEvent(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getContentFromEvent"));
        }
        Content content2 = PinActiveTabAction.getNonToolWindowContent(e2);
        if (content2 == null) {
            content2 = PinActiveTabAction.getToolWindowContent(e2);
        }
        return content2 != null && content2.isValid() ? content2 : null;
    }

    @NotNull
    private static Handler createHandler(final Content content2) {
        Handler handler2 = new Handler(content2.isPinned(), content2.getManager().getSelectedContent() == content2){

            @Override
            void setPinned(boolean value2) {
                content2.setPinned(value2);
            }
        };
        if (handler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/PinActiveTabAction", "createHandler"));
        }
        return handler2;
    }

    @NotNull
    private static Handler createHandler(final EditorWindow window, final VirtualFile selectedFile) {
        Handler handler2 = new Handler(window.isFilePinned(selectedFile), selectedFile.equals(window.getSelectedFile())){

            @Override
            void setPinned(boolean value2) {
                window.setFilePinned(selectedFile, value2);
            }
        };
        if (handler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/PinActiveTabAction", "createHandler"));
        }
        return handler2;
    }

    @Nullable
    private static Content getNonToolWindowContent(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getNonToolWindowContent"));
        }
        Content result2 = null;
        Content[] contents = (Content[])e2.getData(ViewContext.CONTENT_KEY);
        if (contents != null && contents.length == 1) {
            result2 = contents[0];
        }
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(e2.getDataContext(), true);
        Content content2 = result2 = contentManager != null ? contentManager.getSelectedContent() : null;
        if (result2 != null && result2.isPinnable()) {
            return result2;
        }
        return null;
    }

    @Nullable
    private static Content getToolWindowContent(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getToolWindowContent"));
        }
        ToolWindow window = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(e2.getDataContext());
        Content result2 = window != null ? window.getContentManager().getSelectedContent() : null;
        return result2 != null && result2.isPinnable() ? result2 : null;
    }

    @Nullable
    private static VirtualFile getFileInWindow(@NotNull AnActionEvent e2, @NotNull EditorWindow window) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getFileInWindow"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction", "getFileInWindow"));
        }
        VirtualFile file2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 == null) {
            file2 = window.getSelectedFile();
        }
        if (file2 != null && window.isFileOpen(file2)) {
            return file2;
        }
        return null;
    }

    public static class EW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e2, @NotNull EditorWindow window) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$EW", "getFileFromEvent"));
            }
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction$EW", "getFileFromEvent"));
            }
            return window.getSelectedFile();
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$EW", "getContentFromEvent"));
            }
            return null;
        }
    }

    public static class TW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e2, @NotNull EditorWindow window) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$TW", "getFileFromEvent"));
            }
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction$TW", "getFileFromEvent"));
            }
            return null;
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$TW", "getContentFromEvent"));
            }
            return PinActiveTabAction.getToolWindowContent(e2);
        }
    }

    public static abstract class Handler {
        public final boolean isPinned;
        public final boolean isActiveTab;

        abstract void setPinned(boolean var1);

        public Handler(boolean isPinned, boolean isActiveTab) {
            this.isPinned = isPinned;
            this.isActiveTab = isActiveTab;
        }
    }
}

