/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;

public class PrevSplitAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(project2);
            manager.setCurrentWindow(manager.getPrevWindow(manager.getCurrentWindow()));
        }, IdeBundle.message((String)"command.go.to.prev.split", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Project project2 = event.getProject();
        Presentation presentation = event.getPresentation();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(project2);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        presentation.setEnabled(toolWindowManager.isEditorComponentActive() && manager.isInSplitter() && manager.getCurrentWindow() != null);
    }
}

