/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jetbrains.annotations.NotNull;

public class QuickChangeCodeStyleSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "fillActions"));
        }
        final CodeStyleSettingsManager manager = CodeStyleSettingsManager.getInstance((Project)project2);
        if (manager.PER_PROJECT_SETTINGS != null) {
            group.add(new AnAction("<project>", "", manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction$1", "actionPerformed"));
                    }
                    manager.USE_PER_PROJECT_SETTINGS = true;
                }
            });
        }
        CodeStyleScheme currentScheme = CodeStyleSchemes.getInstance().getCurrentScheme();
        for (CodeStyleScheme scheme2 : CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()) {
            QuickChangeCodeStyleSchemeAction.addScheme(group, manager, currentScheme, scheme2, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, final CodeStyleSettingsManager manager, CodeStyleScheme currentScheme, final CodeStyleScheme scheme2, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(scheme2.getName(), "", scheme2 == currentScheme && !manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction$2", "actionPerformed"));
                }
                if (addScheme) {
                    CodeStyleSchemes.getInstance().addScheme(scheme2);
                }
                CodeStyleSchemes.getInstance().setCurrentScheme(scheme2);
                manager.USE_PER_PROJECT_SETTINGS = false;
                manager.PREFERRED_PROJECT_CODE_STYLE = scheme2.getName();
                EditorFactory.getInstance().refreshAllEditors();
            }
        });
    }

    protected boolean isEnabled() {
        return !CodeStyleSchemesImpl.getSchemeManager().getAllSchemes().isEmpty();
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "update"));
        }
        super.update(e2);
        e2.getPresentation().setEnabled(e2.getProject() != null);
    }
}

