/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeColorSchemeAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeColorSchemeAction", "fillActions"));
        }
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme2 : EditorColorsManager.getInstance().getAllSchemes()) {
            QuickChangeColorSchemeAction.addScheme(group, current, scheme2, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme2, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(SchemeManager.getDisplayName((Scheme)scheme2), "", scheme2 == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@Nullable AnActionEvent e2) {
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme2);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme2);
            }
        });
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1;
    }
}

