/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowScrollable;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeToolWindowAction
extends AnAction
implements DumbAware {
    private ToolWindow myLastWindow;
    private ToolWindowManager myLastManager;
    protected JLabel myScrollHelper;
    private ToolWindow myToolWindow;
    private boolean myListenerInstalled;

    protected ResizeToolWindowAction() {
    }

    protected ResizeToolWindowAction(String text2) {
        super(text2);
    }

    protected ResizeToolWindowAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
    }

    protected ResizeToolWindowAction(ToolWindow toolWindow, String originalAction, JComponent c2) {
        this.myToolWindow = toolWindow;
        new ShadowAction((AnAction)this, ActionManager.getInstance().getAction(originalAction), c2);
    }

    public final void update(AnActionEvent e2) {
        Component owner;
        Project project2 = e2.getProject();
        if (project2 == null) {
            this.setDisabled(e2);
            return;
        }
        if (!this.myListenerInstalled) {
            this.myListenerInstalled = true;
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

                public void projectClosed(Project project2) {
                    ResizeToolWindowAction.this.setDisabled(null);
                }
            });
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            this.setDisabled(e2);
            return;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(owner);
        if (!(windowAncestor instanceof IdeFrame) || windowAncestor instanceof IdeFrame.Child) {
            this.setDisabled(e2);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project2);
        ToolWindow window = this.myToolWindow;
        if (window != null || mgr.getActiveToolWindowId() != null) {
            if (window == null) {
                window = mgr.getToolWindow(mgr.getActiveToolWindowId());
            }
            if (!(window != null && window.isAvailable() && window.isVisible() && window.getType() != ToolWindowType.FLOATING && window.getType() != ToolWindowType.WINDOWED && window.isActive())) {
                this.setDisabled(e2);
                return;
            }
            this.update(e2, window, mgr);
            if (e2.getPresentation().isEnabled()) {
                this.myLastWindow = window;
                this.myLastManager = mgr;
            } else {
                this.setDisabled(e2);
            }
        } else {
            this.setDisabled(e2);
        }
    }

    private void setDisabled(@Nullable AnActionEvent e2) {
        if (e2 != null) {
            e2.getPresentation().setEnabled(false);
        }
        this.myLastWindow = null;
        this.myLastManager = null;
        this.myToolWindow = null;
    }

    protected abstract void update(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    public final void actionPerformed(AnActionEvent e2) {
        this.actionPerformed(e2, this.myLastWindow, this.myLastManager);
    }

    @Nullable
    private ToolWindowScrollable getScrollable(ToolWindow wnd, boolean isHorizontalStretchingOffered) {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        DefaultToolWindowScrollable scrollable = null;
        for (Component eachComponent = mgr.getFocusOwner(); eachComponent != null && SwingUtilities.isDescendingFrom(eachComponent, wnd.getComponent()); eachComponent = eachComponent.getParent()) {
            if (!(eachComponent instanceof ToolWindowScrollable)) continue;
            ToolWindowScrollable eachScrollable = (ToolWindowScrollable)eachComponent;
            if (isHorizontalStretchingOffered) {
                if (!eachScrollable.isHorizontalScrollingNeeded()) continue;
                scrollable = eachScrollable;
                break;
            }
            if (!eachScrollable.isVerticalScrollingNeeded()) continue;
            scrollable = eachScrollable;
            break;
        }
        if (scrollable == null) {
            scrollable = new DefaultToolWindowScrollable();
        }
        if (isHorizontalStretchingOffered && scrollable.isHorizontalScrollingNeeded()) {
            return scrollable;
        }
        if (!isHorizontalStretchingOffered && scrollable.isVerticalScrollingNeeded()) {
            return scrollable;
        }
        return null;
    }

    protected abstract void actionPerformed(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    protected void stretch(ToolWindow wnd, boolean isHorizontalStretching, boolean isIncrementAction) {
        ToolWindowScrollable scrollable = this.getScrollable(wnd, isHorizontalStretching);
        if (scrollable == null) {
            return;
        }
        ToolWindowAnchor anchor = wnd.getAnchor();
        if (isHorizontalStretching && !anchor.isHorizontal()) {
            ResizeToolWindowAction.incWidth(wnd, scrollable.getNextHorizontalScroll(), anchor == ToolWindowAnchor.LEFT == isIncrementAction);
        } else if (!isHorizontalStretching && anchor.isHorizontal()) {
            ResizeToolWindowAction.incHeight(wnd, scrollable.getNextVerticalScroll(), anchor == ToolWindowAnchor.TOP != isIncrementAction);
        }
    }

    private static void incWidth(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchWidth(isPositive ? value2 : -value2);
    }

    private static void incHeight(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchHeight(isPositive ? value2 : -value2);
    }

    private Dimension getReferenceSize() {
        if (this.myScrollHelper == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.myScrollHelper = new JLabel("W");
            } else {
                return new Dimension(1, 1);
            }
        }
        return this.myScrollHelper.getPreferredSize();
    }

    private class DefaultToolWindowScrollable
    implements ToolWindowScrollable {
        private DefaultToolWindowScrollable() {
        }

        public boolean isHorizontalScrollingNeeded() {
            return true;
        }

        public int getNextHorizontalScroll() {
            return ((ResizeToolWindowAction)ResizeToolWindowAction.this).getReferenceSize().width * Registry.intValue((String)"ide.windowSystem.hScrollChars");
        }

        public boolean isVerticalScrollingNeeded() {
            return true;
        }

        public int getNextVerticalScroll() {
            return ((ResizeToolWindowAction)ResizeToolWindowAction.this).getReferenceSize().height * Registry.intValue((String)"ide.windowSystem.vScrollChars");
        }
    }

    public static class Down
    extends ResizeToolWindowAction {
        public Down() {
        }

        public Down(String text2) {
            super(text2);
        }

        public Down(String text2, String description, Icon icon) {
            super(text2, description, icon);
        }

        public Down(ToolWindow toolWindow, JComponent c2) {
            super(toolWindow, "ResizeToolWindowDown", c2);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e2, ToolWindow wnd, ToolWindowManager mgr) {
            this.stretch(wnd, false, false);
        }
    }

    public static class Up
    extends ResizeToolWindowAction {
        public Up() {
        }

        public Up(String text2) {
            super(text2);
        }

        public Up(String text2, String description, Icon icon) {
            super(text2, description, icon);
        }

        public Up(ToolWindow toolWindow, JComponent c2) {
            super(toolWindow, "ResizeToolWindowUp", c2);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e2, ToolWindow wnd, ToolWindowManager mgr) {
            this.stretch(wnd, false, true);
        }
    }

    public static class Right
    extends ResizeToolWindowAction {
        public Right() {
        }

        public Right(String text2) {
            super(text2);
        }

        public Right(String text2, String description, Icon icon) {
            super(text2, description, icon);
        }

        public Right(ToolWindow toolWindow, JComponent c2) {
            super(toolWindow, "ResizeToolWindowRight", c2);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e2, ToolWindow wnd, ToolWindowManager mgr) {
            this.stretch(wnd, true, true);
        }
    }

    public static class Left
    extends ResizeToolWindowAction {
        public Left() {
        }

        public Left(String text2) {
            super(text2);
        }

        public Left(String text2, String description, Icon icon) {
            super(text2, description, icon);
        }

        public Left(ToolWindow toolWindow, JComponent c2) {
            super(toolWindow, "ResizeToolWindowLeft", c2);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e2, ToolWindow wnd, ToolWindowManager mgr) {
            this.stretch(wnd, true, false);
        }
    }
}

