/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;

public class SearchAgainAction
extends AnAction
implements DumbAware {
    public SearchAgainAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        FileEditor editor = (FileEditor)e2.getData(PlatformDataKeys.FILE_EDITOR);
        if (editor == null || project2 == null) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            FindManager findManager = FindManager.getInstance((Project)project2);
            if (!findManager.selectNextOccurrenceWasPerformed() && findManager.findNextUsageInEditor(editor)) {
                return;
            }
            FindUtil.searchAgain(project2, editor, e2.getDataContext());
        }, IdeBundle.message((String)"command.find.next", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditor editor = (FileEditor)event.getData(PlatformDataKeys.FILE_EDITOR);
        presentation.setEnabled(editor instanceof TextEditor);
    }
}

