/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectInAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.select.in");
        SelectInContext context2 = SelectInContextImpl.createContext(e2);
        if (context2 == null) {
            return;
        }
        SelectInAction.invoke(e2.getDataContext(), context2);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SelectInAction", "beforeActionPerformedUpdate"));
        }
        Project project2 = e2.getProject();
        if (project2 != null) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e2);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (SelectInContextImpl.createContext(event) == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
        }
    }

    private static void invoke(@NotNull DataContext dataContext, @NotNull SelectInContext context2) {
        ListPopup popup2;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/SelectInAction", "invoke"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/actions/SelectInAction", "invoke"));
        }
        List<SelectInTarget> targetVector = Arrays.asList(SelectInAction.getSelectInManager(context2.getProject()).getTargets());
        if (targetVector.isEmpty()) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new NoTargetsAction());
            popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        } else {
            popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new SelectInActionsStep(targetVector, context2));
        }
        popup2.showInBestPositionFor(dataContext);
    }

    private static String numberingText(int n2, String text2) {
        text2 = n2 < 9 ? "&" + (n2 + 1) + ". " + text2 : (n2 == 9 ? "&0. " + text2 : "&" + (char)(65 + n2 - 10) + ". " + text2);
        return text2;
    }

    private static SelectInManager getSelectInManager(Project project2) {
        return SelectInManager.getInstance((Project)project2);
    }

    private static class NoTargetsAction
    extends AnAction {
        public NoTargetsAction() {
            super(IdeBundle.message((String)"message.no.targets.available", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e2) {
        }
    }

    private static class SelectInActionsStep
    extends BaseListPopupStep<SelectInTarget> {
        @NotNull
        private final SelectInContext mySelectInContext;
        private final List<SelectInTarget> myVisibleTargets;

        public SelectInActionsStep(@NotNull Collection<SelectInTarget> targetVector, @NotNull SelectInContext selectInContext) {
            if (targetVector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetVector", "com/intellij/ide/actions/SelectInAction$SelectInActionsStep", "<init>"));
            }
            if (selectInContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectInContext", "com/intellij/ide/actions/SelectInAction$SelectInActionsStep", "<init>"));
            }
            this.mySelectInContext = selectInContext;
            this.myVisibleTargets = new ArrayList<SelectInTarget>();
            for (SelectInTarget target : targetVector) {
                this.myVisibleTargets.add(target);
            }
            this.init(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), this.myVisibleTargets, null);
        }

        @NotNull
        public String getTextFor(SelectInTarget value2) {
            ToolWindow toolWindow;
            String text2 = value2.toString();
            String id = value2.getMinorViewId() == null ? value2.getToolWindowId() : null;
            ToolWindow toolWindow2 = toolWindow = id == null ? null : ToolWindowManager.getInstance((Project)this.mySelectInContext.getProject()).getToolWindow(id);
            if (toolWindow != null) {
                text2 = text2.replace(value2.getToolWindowId(), toolWindow.getStripeTitle());
            }
            int n2 = this.myVisibleTargets.indexOf(value2);
            String string2 = SelectInAction.numberingText(n2, text2);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInAction$SelectInActionsStep", "getTextFor"));
            }
            return string2;
        }

        public PopupStep onChosen(SelectInTarget target, boolean finalChoice) {
            ArrayList<SelectInTarget> subTargets;
            if (finalChoice) {
                PsiDocumentManager.getInstance((Project)this.mySelectInContext.getProject()).commitAllDocuments();
                target.selectIn(this.mySelectInContext, true);
                return FINAL_CHOICE;
            }
            if (target instanceof CompositeSelectInTarget && (subTargets = new ArrayList<SelectInTarget>(((CompositeSelectInTarget)target).getSubTargets(this.mySelectInContext))).size() > 0) {
                Collections.sort(subTargets, new SelectInManager.SelectInTargetComparator());
                return new SelectInActionsStep(subTargets, this.mySelectInContext);
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(SelectInTarget selectedValue) {
            return selectedValue instanceof CompositeSelectInTarget && ((CompositeSelectInTarget)selectedValue).getSubTargets(this.mySelectInContext).size() > 1;
        }

        public boolean isSelectable(SelectInTarget target) {
            if (DumbService.isDumb((Project)this.mySelectInContext.getProject()) && !DumbService.isDumbAware((Object)target)) {
                return false;
            }
            return target.canSelect(this.mySelectInContext);
        }

        public boolean isMnemonicsNavigationEnabled() {
            return true;
        }
    }
}

