/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SelectInProjectViewAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e2) {
        ProjectPaneSelectInTarget target = new ProjectPaneSelectInTarget(e2.getProject());
        SelectInContext context2 = SelectInContextImpl.createContext(e2);
        if (context2 != null) {
            target.selectIn(context2, true);
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SelectInProjectViewAction", "beforeActionPerformedUpdate"));
        }
        Project project2 = e2.getProject();
        if (project2 != null) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e2);
    }

    public void update(AnActionEvent e2) {
        Project project2 = e2.getProject();
        if (project2 != null) {
            ProjectPaneSelectInTarget target = new ProjectPaneSelectInTarget(project2);
            SelectInContext context2 = SelectInContextImpl.createContext(e2);
            if (context2 != null && target.canSelect(context2)) {
                e2.getPresentation().setEnabled(true);
                return;
            }
        }
        e2.getPresentation().setEnabled(false);
    }
}

