/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.ui.UIUtil;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        SendFeedbackAction.launchBrowser(e2.getProject());
    }

    public static void launchBrowser(@Nullable Project project2) {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean eap = appInfo.isEAP();
        String urlTemplate = eap ? appInfo.getEAPFeedbackUrl() : appInfo.getReleaseFeedbackUrl();
        urlTemplate = urlTemplate.replace("$BUILD", eap ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString()).replace("$TIMEZONE", System.getProperty("user.timezone")).replace("$EVAL", SendFeedbackAction.isEvaluationLicense() ? "true" : "false").replace("$DESCR", SendFeedbackAction.getDescription());
        BrowserUtil.browse((String)urlTemplate, (Project)project2);
    }

    public static String getDescription() {
        String javaVendor;
        StringBuilder sb2 = new StringBuilder("\n\n");
        sb2.append(ApplicationInfoEx.getInstanceEx().getBuild().asString()).append(", ");
        String javaVersion = System.getProperty("java.runtime.version", System.getProperty("java.version", "unknown"));
        sb2.append("JRE ");
        sb2.append(javaVersion);
        String archDataModel = System.getProperty("sun.arch.data.model");
        if (archDataModel != null) {
            sb2.append("x").append(archDataModel);
        }
        if ((javaVendor = System.getProperty("java.vm.vendor")) != null) {
            sb2.append(" ").append(javaVendor);
        }
        sb2.append(", OS ").append(System.getProperty("os.name"));
        String osArch = System.getProperty("os.arch");
        if (osArch != null) {
            sb2.append("(").append(osArch).append(")");
        }
        String osVersion = System.getProperty("os.version");
        String osPatchLevel = System.getProperty("sun.os.patch.level");
        if (osVersion != null) {
            sb2.append(" v").append(osVersion);
            if (osPatchLevel != null) {
                sb2.append(" ").append(osPatchLevel);
            }
        }
        if (!GraphicsEnvironment.isHeadless()) {
            sb2.append(", screens ");
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int i2 = 0; i2 < devices.length; ++i2) {
                if (i2 > 0) {
                    sb2.append(", ");
                }
                GraphicsDevice device = devices[i2];
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                sb2.append(bounds.width).append("x").append(bounds.height);
            }
            if (UIUtil.isRetina()) {
                sb2.append(SystemInfo.isMac ? "; Retina" : "; HiDPI");
            }
        }
        return sb2.toString();
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(ApplicationInfoEx.getInstanceEx() != null);
    }

    private static boolean isEvaluationLicense() {
        LicensingFacade provider = LicensingFacade.getInstance();
        return provider != null && provider.isEvaluationLicense();
    }
}

