/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ShowContentAction
extends AnAction
implements DumbAware {
    private ToolWindow myWindow;

    public ShowContentAction() {
    }

    public ShowContentAction(ToolWindow window, JComponent c2) {
        this.myWindow = window;
        AnAction original = ActionManager.getInstance().getAction("ShowContent");
        new ShadowAction((AnAction)this, original, c2);
        this.copyFrom(original);
    }

    public void update(AnActionEvent e2) {
        ToolWindow window = this.getWindow(e2);
        e2.getPresentation().setEnabledAndVisible(window != null && window.getContentManager().getContentCount() > 1);
        e2.getPresentation().setText(window == null || window.getContentUiType() == ToolWindowContentUiType.TABBED ? "Show List of Tabs" : "Show List of Views");
    }

    public void actionPerformed(AnActionEvent e2) {
        this.getWindow(e2).showContentPopup(e2.getInputEvent());
    }

    @Nullable
    private ToolWindow getWindow(AnActionEvent event) {
        if (this.myWindow != null) {
            return this.myWindow;
        }
        Project project2 = event.getProject();
        if (project2 == null) {
            return null;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow window = manager.getToolWindow(manager.getActiveToolWindowId());
        if (window == null) {
            return null;
        }
        Component context2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext());
        if (context2 == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(window.getComponent(), context2) ? window : null;
    }
}

