/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");

    @NotNull
    private static Project getProject(@Nullable Project project2) {
        Project project3 = project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getProject"));
        }
        return project3;
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project2, @NotNull ConfigurableGroup[] groups2, @Nullable Configurable toSelect) {
        if (groups2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        project2 = ShowSettingsUtilImpl.getProject(project2);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups2);
        DialogWrapper dialogWrapper = SettingsDialogFactory.getInstance().create(project2, filteredGroups, toSelect, null);
        if (dialogWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getDialog"));
        }
        return dialogWrapper;
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project2, boolean withIdeSettings) {
        if (!withIdeSettings) {
            project2 = ShowSettingsUtilImpl.getProject(project2);
        }
        ConfigurableGroup[] configurableGroupArray = new ConfigurableGroup[]{ConfigurableExtensionPointUtil.getConfigurableGroup(project2, withIdeSettings)};
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurableGroups"));
        }
        return configurableGroupArray;
    }

    @NotNull
    public static Configurable[] getConfigurables(@Nullable Project project2, boolean withGroupReverseOrder) {
        Configurable[] configurableArray = ShowSettingsUtilImpl.getConfigurables(ShowSettingsUtilImpl.getConfigurableGroups(project2, true), withGroupReverseOrder);
        if (configurableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurableArray;
    }

    @NotNull
    private static Configurable[] getConfigurables(@NotNull ConfigurableGroup[] groups2, boolean withGroupReverseOrder) {
        if (groups2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        Configurable[][] arrays = new Configurable[groups2.length][];
        int length = 0;
        for (int i2 = 0; i2 < groups2.length; ++i2) {
            arrays[i2] = groups2[withGroupReverseOrder ? groups2.length - 1 - i2 : i2].getConfigurables();
            length += arrays[i2].length;
        }
        Configurable[] configurables = new Configurable[length];
        int offset = 0;
        for (Configurable[] array2 : arrays) {
            System.arraycopy(array2, 0, configurables, offset, array2.length);
            offset += array2.length;
        }
        if (configurables == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "getConfigurables"));
        }
        return configurables;
    }

    public void showSettingsDialog(@NotNull Project project2, ConfigurableGroup ... group) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        try {
            ShowSettingsUtilImpl.getDialog(project2, group, null).show();
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
    }

    public void showSettingsDialog(@Nullable Project project2, Class configurableClass) {
        this.showSettingsDialog(project2, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project2, @NotNull Class<T> configurableClass, @Nullable Consumer<T> additionalConfiguration) {
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        ConfigurableGroup[] groups2 = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Configurable config = new ConfigurableVisitor.ByType(configurableClass).find(groups2);
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        if (additionalConfiguration != null) {
            Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)config);
            assert (toConfigure != null) : "Wrong configurable found: " + config.getClass();
            additionalConfiguration.accept(toConfigure);
        }
        ShowSettingsUtilImpl.getDialog(project2, groups2, config).show();
    }

    public void showSettingsDialog(@Nullable Project project2, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToSelect", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ConfigurableGroup[] groups2 = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project2);
        groups2 = ShowSettingsUtilImpl.filterEmptyGroups(groups2);
        ShowSettingsUtilImpl.getDialog(actualProject, groups2, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups2)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups2) {
        List<Configurable> all2 = SearchUtil.expand(groups2);
        for (Configurable each : all2) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project2, String id2Select, String filter2) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project2, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        Configurable configurable2Select = id2Select == null ? null : new ConfigurableVisitor.ByID(id2Select).find(group);
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project2), group, configurable2Select, filter2).show();
    }

    public void showSettingsDialog(@NotNull Project project2, Configurable toSelect) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ShowSettingsUtilImpl", "showSettingsDialog"));
        }
        ShowSettingsUtilImpl.getDialog(project2, ShowSettingsUtilImpl.getConfigurableGroups(project2, true), toSelect).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        ArrayList<ConfigurableGroup> groups2 = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g2 : group) {
            if (g2.getConfigurables().length <= 0) continue;
            groups2.add(g2);
        }
        ConfigurableGroup[] configurableGroupArray = groups2.toArray(new ConfigurableGroup[groups2.size()]);
        if (configurableGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "filterEmptyGroups"));
        }
        return configurableGroupArray;
    }

    public boolean editConfigurable(Project project2, Configurable configurable) {
        return this.editConfigurable(project2, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findApplicationConfigurable(confClass);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project2, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project2, confClass);
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(project2, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "isWorthToShowApplyButton"));
        }
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project2, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project2, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project2, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project2, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "editConfigurable"));
        }
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project2, dimensionKey, configurable, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        String string2 = '#' + StringUtil.replaceChar((String)StringUtil.replaceChar((String)configurable.getDisplayName(), (char)'\n', (char)'_'), (char)' ', (char)'_');
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowSettingsUtilImpl", "createDimensionKey"));
        }
        return string2;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }
}

