/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.Nullable;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e2) {
        VirtualFile[] files2 = SynchronizeCurrentFileAction.getFiles(e2);
        if (SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e2) == null || files2 == null || files2.length == 0) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setEnabledAndVisible(true);
        e2.getPresentation().setText(SynchronizeCurrentFileAction.getMessage(files2));
    }

    private static String getMessage(VirtualFile[] files2) {
        return files2.length == 1 ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)files2[0].getName(), (int)20))}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e2);
        VirtualFile[] files2 = SynchronizeCurrentFileAction.getFiles(e2);
        if (project2 == null || files2 == null || files2.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file2 : files2) {
                if (!(file2 instanceof NewVirtualFile)) continue;
                ((NewVirtualFile)file2).markDirtyRecursively();
            }
        });
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project2, files2), files2);
    }

    private static void postRefresh(Project project2, VirtualFile[] files2) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
        for (VirtualFile f2 : files2) {
            if (f2.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(f2);
                continue;
            }
            dirtyScopeManager.fileDirty(f2);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files2)}));
        }
    }

    @Nullable
    private static VirtualFile[] getFiles(AnActionEvent e2) {
        return (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }
}

