/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.actions.TogglePresentationModeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.annotations.NotNull;

public class ToggleDistractionFreeModeAction
extends DumbAwareAction {
    private static final String key = "editor.distraction.free.mode";

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "update"));
        }
        if (e2.getProject() == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        String text2 = Registry.is((String)key) ? ActionsBundle.message((String)"action.ToggleDistractionFreeMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ToggleDistractionFreeMode.enter", (Object[])new Object[0]);
        e2.getPresentation().setText(text2);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        ToggleDistractionFreeModeAction.alternateCurrentDistractionFreeModeSetting();
        boolean enter = ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled();
        if (project2 == null) {
            return;
        }
        PropertiesComponent p2 = PropertiesComponent.getInstance();
        UISettings ui = UISettings.getInstance();
        EditorSettingsExternalizable.OptionSet eo = EditorSettingsExternalizable.getInstance().getOptions();
        DaemonCodeAnalyzerSettings ds = DaemonCodeAnalyzerSettings.getInstance();
        String before = "BEFORE.DISTRACTION.MODE.";
        String after2 = "AFTER.DISTRACTION.MODE.";
        if (enter) {
            ToggleDistractionFreeModeAction.applyAndSave(p2, ui, eo, ds, before, after2, false);
            TogglePresentationModeAction.storeToolWindows(project2);
        } else {
            ToggleDistractionFreeModeAction.applyAndSave(p2, ui, eo, ds, after2, before, true);
            TogglePresentationModeAction.restoreToolWindows(project2, true, false);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
        DaemonCodeAnalyzer.getInstance((Project)project2).settingsChanged();
        EditorFactory.getInstance().refreshAllEditors();
    }

    public static void applyAndSave(@NotNull PropertiesComponent p2, @NotNull UISettings ui, @NotNull EditorSettingsExternalizable.OptionSet eo, @NotNull DaemonCodeAnalyzerSettings ds, String before, String after2, boolean value2) {
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (eo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eo", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/ide/actions/ToggleDistractionFreeModeAction", "applyAndSave"));
        }
        p2.setValue(before + "SHOW_STATUS_BAR", String.valueOf(ui.getShowStatusBar()));
        ui.setShowStatusBar(p2.getBoolean(after2 + "SHOW_STATUS_BAR", value2));
        p2.setValue(before + "SHOW_MAIN_TOOLBAR", String.valueOf(ui.getShowMainToolbar()));
        ui.setShowMainToolbar(p2.getBoolean(after2 + "SHOW_MAIN_TOOLBAR", value2));
        p2.setValue(before + "SHOW_NAVIGATION_BAR", String.valueOf(ui.getShowNavigationBar()));
        ui.setShowNavigationBar(p2.getBoolean(after2 + "SHOW_NAVIGATION_BAR", value2));
        p2.setValue(before + "IS_FOLDING_OUTLINE_SHOWN", String.valueOf(eo.IS_FOLDING_OUTLINE_SHOWN));
        eo.IS_FOLDING_OUTLINE_SHOWN = p2.getBoolean(after2 + "IS_FOLDING_OUTLINE_SHOWN", value2);
        p2.setValue(before + "IS_WHITESPACES_SHOWN", String.valueOf(eo.IS_WHITESPACES_SHOWN));
        eo.IS_WHITESPACES_SHOWN = p2.getBoolean(after2 + "IS_WHITESPACES_SHOWN", value2);
        p2.setValue(before + "ARE_LINE_NUMBERS_SHOWN", String.valueOf(eo.ARE_LINE_NUMBERS_SHOWN));
        eo.ARE_LINE_NUMBERS_SHOWN = p2.getBoolean(after2 + "ARE_LINE_NUMBERS_SHOWN", value2);
        p2.setValue(before + "ARE_GUTTER_ICONS_SHOWN", String.valueOf(eo.ARE_GUTTER_ICONS_SHOWN));
        eo.ARE_GUTTER_ICONS_SHOWN = p2.getBoolean(after2 + "ARE_GUTTER_ICONS_SHOWN", value2);
        p2.setValue(before + "IS_RIGHT_MARGIN_SHOWN", String.valueOf(eo.IS_RIGHT_MARGIN_SHOWN));
        eo.IS_RIGHT_MARGIN_SHOWN = p2.getBoolean(after2 + "IS_RIGHT_MARGIN_SHOWN", value2);
        p2.setValue(before + "IS_INDENT_GUIDES_SHOWN", String.valueOf(eo.IS_INDENT_GUIDES_SHOWN));
        eo.IS_INDENT_GUIDES_SHOWN = p2.getBoolean(after2 + "IS_INDENT_GUIDES_SHOWN", value2);
        p2.setValue(before + "SHOW_BREADCRUMBS", String.valueOf(eo.SHOW_BREADCRUMBS));
        eo.SHOW_BREADCRUMBS = p2.getBoolean(after2 + "SHOW_BREADCRUMBS", value2);
        p2.setValue(before + "SHOW_METHOD_SEPARATORS", String.valueOf(ds.SHOW_METHOD_SEPARATORS));
        ds.SHOW_METHOD_SEPARATORS = p2.getBoolean(after2 + "SHOW_METHOD_SEPARATORS", value2);
        p2.setValue(before + "HIDE_TOOL_STRIPES", String.valueOf(ui.getHideToolStripes()));
        ui.setHideToolStripes(p2.getBoolean(after2 + "HIDE_TOOL_STRIPES", !value2));
        p2.setValue(before + "EDITOR_TAB_PLACEMENT", String.valueOf(ui.getEditorTabPlacement()));
        ui.setEditorTabPlacement(p2.getInt(after2 + "EDITOR_TAB_PLACEMENT", value2 ? 1 : 0));
    }

    public static boolean isDistractionFreeModeEnabled() {
        return Registry.get((String)key).asBoolean();
    }

    private static void alternateCurrentDistractionFreeModeSetting() {
        RegistryValue value2;
        value2.setValue(!(value2 = Registry.get((String)key)).asBoolean());
    }
}

