/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ToggleReadOnlyAttributeAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleReadOnlyAttributeAction", "update"));
        }
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e2.getDataContext());
        e2.getPresentation().setEnabledAndVisible(files2.length > 0);
        if (files2.length > 0) {
            int ro = 0;
            int rw = 0;
            int f2 = 0;
            int d2 = 0;
            for (VirtualFile file2 : files2) {
                if (file2.isWritable()) {
                    ++rw;
                } else {
                    ++ro;
                }
                if (file2.isDirectory()) {
                    ++d2;
                    continue;
                }
                ++f2;
            }
            if (ro > 0 && rw > 0) {
                e2.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.text", (Object[])new Object[0]));
            } else if (f2 > 0 && d2 == 0) {
                e2.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.files", (Object[])new Object[]{ro, rw, f2, d2}));
            } else if (f2 == 0 && d2 > 0) {
                e2.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.dirs", (Object[])new Object[]{ro, rw, f2, d2}));
            } else {
                e2.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.mixed", (Object[])new Object[]{ro, rw, f2, d2}));
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleReadOnlyAttributeAction", "actionPerformed"));
        }
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e2.getDataContext());
        if (files2.length > 0) {
            WriteAction.run(() -> {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleReadOnlyAttributeAction", "lambda$actionPerformed$0"));
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                try {
                    for (VirtualFile file2 : files2) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)file2.isWritable());
                    }
                }
                catch (IOException x2) {
                    Notifications.Bus.notify((Notification)new Notification("System Messages", CommonBundle.getErrorTitle(), x2.getMessage(), NotificationType.ERROR), (Project)e2.getProject());
                }
            });
        }
    }

    private static VirtualFile[] getFiles(DataContext context2) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
        return files2 == null ? VirtualFile.EMPTY_ARRAY : (VirtualFile[])Stream.of(files2).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
    }
}

