/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Producer<Iterable<JComponent>> myProducer;

    @NotNull
    public static ActionGroup createToggleToolbarGroup(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ToggleToolbarAction", "createToggleToolbarGroup"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ToggleToolbarAction", "createToggleToolbarGroup"));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow), ToggleToolbarAction.createToolWindowAction(toolWindow, PropertiesComponent.getInstance((Project)project2)), Separator.getInstance()});
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "createToggleToolbarGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Producer<Iterable<JComponent>> components) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/actions/ToggleToolbarAction", "createAction"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "createAction"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/ide/actions/ToggleToolbarAction", "createAction"));
        }
        ToggleToolbarAction toggleToolbarAction = new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id), components);
        if (toggleToolbarAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "createAction"));
        }
        return toggleToolbarAction;
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow, final @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ToggleToolbarAction", "createToolWindowAction"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "createToolWindowAction"));
        }
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                ContentManager contentManager;
                JComponent component = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible((Iterable<JComponent>)JBIterable.of((Object)component), ToggleToolbarAction.isToolbarVisible(toolWindow, properties));
                ContentManager contentManager2 = contentManager = component instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)component) : null;
                if (contentManager != null) {
                    contentManager.addContentManagerListener((ContentManagerListener)this);
                }
            }
        });
        ToggleToolbarAction toggleToolbarAction = new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow), (Producer<Iterable<JComponent>>)((Producer)() -> {
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ToggleToolbarAction", "lambda$createToolWindowAction$0"));
            }
            return JBIterable.of((Object)toolWindow.getContentManager().getComponent());
        }));
        if (toggleToolbarAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "createToolWindowAction"));
        }
        return toggleToolbarAction;
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow), properties, (Iterable<JComponent>)JBIterable.of((Object)toolWindow.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id, @NotNull PropertiesComponent properties, @NotNull Iterable<JComponent> components, @Nullable Boolean visible) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id), properties, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<JComponent> roots, boolean state) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisible"));
        }
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots)) {
            JComponent c2 = toolbar.getComponent();
            c2.setVisible(state);
            Container parent = c2.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/ide/actions/ToggleToolbarAction", "isToolbarVisible"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "isToolbarVisible"));
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ToggleToolbarAction", "isToolbarVisible"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "isToolbarVisible"));
        }
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Producer<Iterable<JComponent>> producer) {
        if (propertiesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/intellij/ide/actions/ToggleToolbarAction", "<init>"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/ide/actions/ToggleToolbarAction", "<init>"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/ide/actions/ToggleToolbarAction", "<init>"));
        }
        super("Show Toolbar");
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ToggleToolbarAction", "update"));
        }
        super.update(e2);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars((Iterable)this.myProducer.produce()).iterator().hasNext();
        e2.getPresentation().setVisible(hasToolbars);
    }

    public boolean isSelected(AnActionEvent e2) {
        return this.isSelected();
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, (Iterable)this.myProducer.produce(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<JComponent> components, boolean visible) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisibleImpl"));
        }
        if (propertiesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisibleImpl"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/ide/actions/ToggleToolbarAction", "setToolbarVisibleImpl"));
        }
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/actions/ToggleToolbarAction", "isSelectedImpl"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/ide/actions/ToggleToolbarAction", "isSelectedImpl"));
        }
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/ToggleToolbarAction", "getShowToolbarProperty"));
        }
        String string2 = ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "getShowToolbarProperty"));
        }
        return string2;
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/actions/ToggleToolbarAction", "getShowToolbarProperty"));
        }
        String string2 = s2 + ".ShowToolbar";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "getShowToolbarProperty"));
        }
        return string2;
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<JComponent> roots) {
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction", "iterateToolbars"));
        }
        return jBIterable;
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        public OptionsGroup(ToolWindow toolWindow) {
            super("View Options", true);
            this.myToolWindow = toolWindow;
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty((ActionGroup)this, (AnActionEvent)e2, (boolean)LaterInvocator.isInModalContext()));
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e2) {
            JComponent contentComponent;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            List result2 = ContainerUtil.newSmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars((Iterable)JBIterable.of((Object)contentComponent))) {
                JComponent c2 = toolbar.getComponent();
                if (c2.isVisible() || !c2.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem((List)result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List actions2 = toolbar.getActions();
                for (AnAction action2 : actions2) {
                    if (action2 instanceof ToggleAction && !result2.contains(action2)) {
                        result2.add(action2);
                        continue;
                    }
                    if (!(action2 instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem((List)result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup2 = result2.size() > 3;
            this.setPopup(popup2);
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToggleToolbarAction$OptionsGroup", "getChildren"));
            }
            return anActionArray;
        }
    }
}

