/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WeighingActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.WeighingActionGroup");
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public void update(AnActionEvent e2) {
        this.getDelegate().update(e2);
    }

    protected abstract ActionGroup getDelegate();

    private static void getAllChildren(@Nullable AnActionEvent e2, ActionGroup group, List<AnAction> result2) {
        for (AnAction action2 : group.getChildren(e2)) {
            if (action2 == null) {
                LOG.error("Null child for " + group + " of class " + group.getClass());
                continue;
            }
            if (action2 instanceof ActionGroup && !((ActionGroup)action2).isPopup()) {
                WeighingActionGroup.getAllChildren(e2, (ActionGroup)action2, result2);
                continue;
            }
            result2.add(action2);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        AnAction[] children2 = this.getDelegate().getChildren(e2);
        if (e2 == null) {
            if (children2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
            }
            return children2;
        }
        ArrayList<AnAction> all2 = new ArrayList<AnAction>();
        WeighingActionGroup.getAllChildren(e2, this.getDelegate(), all2);
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action2 : all2) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action2);
            presentation.setWeight(0.0);
            Utils.updateGroupChild(e2.getDataContext(), e2.getPlace(), action2, presentation);
            if (!presentation.isEnabled() || !presentation.isVisible()) continue;
            if (presentation.getWeight() > maxWeight) {
                maxWeight = presentation.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action2);
        }
        if (heaviest == null) {
            if (children2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
            }
            return children2;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action3 : all2) {
            boolean separator = action3 instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action3);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action3)) {
                heaviest.add(action3);
            }
            if (!heaviest.contains(action3)) continue;
            chosen.add(action3);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(this.getDelegate(), heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText("Other...");
        AnAction[] anActionArray = new AnAction[]{chosen, new Separator(), other};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/WeighingActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    protected boolean shouldBeChosenAnyway(AnAction action2) {
        return false;
    }
}

