/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BookmarkItem
extends ItemWrapper
implements Comparable<BookmarkItem> {
    private final Bookmark myBookmark;

    public BookmarkItem(Bookmark bookmark) {
        this.myBookmark = bookmark;
    }

    public Bookmark getBookmark() {
        return this.myBookmark;
    }

    public void setupRenderer(ColoredListCellRenderer renderer, Project project2, boolean selected) {
        BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, project2, this.myBookmark, selected);
    }

    public static void setupRenderer(SimpleColoredComponent renderer, Project project2, Bookmark bookmark, boolean selected) {
        String description;
        PsiDirectory fileOrDir;
        VirtualFile file2 = bookmark.getFile();
        if (!file2.isValid()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Object object = fileOrDir = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        if (fileOrDir != null) {
            renderer.setIcon(fileOrDir.getIcon(0));
        }
        if ((description = bookmark.getDescription()) != null) {
            renderer.append(description + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
        renderer.append(file2.getName(), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
        if (bookmark.getLine() >= 0) {
            renderer.append(":", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            renderer.append(String.valueOf(bookmark.getLine() + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        renderer.append(" (" + VfsUtilCore.getRelativeLocation((VirtualFile)file2, (VirtualFile)project2.getBaseDir()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!selected) {
            Color color;
            FileColorManager colorManager = FileColorManager.getInstance((Project)project2);
            if (fileOrDir instanceof PsiFile && (color = colorManager.getRendererBackground((PsiFile)fileOrDir)) != null) {
                renderer.setBackground(color);
            }
        }
    }

    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project2, boolean selected) {
        BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, project2, this.myBookmark, selected);
    }

    public void updateAccessoryView(JComponent component) {
        JLabel label = (JLabel)component;
        char mnemonic = this.myBookmark.getMnemonic();
        if (mnemonic != '\u0000') {
            label.setText(Character.toString(mnemonic) + '.');
        } else {
            label.setText("");
        }
    }

    public String speedSearchText() {
        return this.myBookmark.getFile().getName() + " " + this.myBookmark.getDescription();
    }

    public String footerText() {
        return this.myBookmark.getFile().getPresentableUrl();
    }

    protected void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        panel2.navigateInPreviewEditor(DetailView.PreviewEditorState.create((VirtualFile)this.myBookmark.getFile(), (int)this.myBookmark.getLine()));
    }

    public boolean allowedToRemove() {
        return true;
    }

    public void removed(Project project2) {
        BookmarkManager.getInstance(project2).removeBookmark(this.getBookmark());
    }

    @Override
    public int compareTo(BookmarkItem o2) {
        return this.myBookmark.compareTo(o2.myBookmark);
    }
}

