/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public class ToggleBookmarkAction
extends BookmarksAction
implements DumbAware {
    public ToggleBookmarkAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.bookmark.toggle", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/bookmarks/actions/ToggleBookmarkAction", "update"));
        }
        Project project2 = event.getProject();
        DataContext dataContext = event.getDataContext();
        event.getPresentation().setEnabled(project2 != null && (ToolWindowManager.getInstance((Project)project2).isEditorComponentActive() && CommonDataKeys.EDITOR.getData(dataContext) != null || CommonDataKeys.VIRTUAL_FILE.getData(dataContext) != null));
        event.getPresentation().setText(IdeBundle.message((String)"action.bookmark.toggle", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/ToggleBookmarkAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(e2.getDataContext(), project2).invoke();
        if (info.getFile() == null) {
            return;
        }
        if (info.getBookmarkAtPlace() != null) {
            BookmarkManager.getInstance(project2).removeBookmark(info.getBookmarkAtPlace());
        } else {
            BookmarkManager.getInstance(project2).addTextBookmark(info.getFile(), info.getLine(), "");
        }
    }
}

