/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.ide.bookmarks.actions.MnemonicChooser;
import com.intellij.ide.bookmarks.actions.ToggleBookmarkAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ToggleBookmarkWithMnemonicAction
extends ToggleBookmarkAction {
    public ToggleBookmarkWithMnemonicAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.bookmark.toggle.mnemonic", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/ToggleBookmarkWithMnemonicAction", "update"));
        }
        super.update(e2);
        e2.getPresentation().setText(IdeBundle.message((String)"action.bookmark.toggle.mnemonic", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/actions/ToggleBookmarkWithMnemonicAction", "actionPerformed"));
        }
        super.actionPerformed(e2);
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(e2.getDataContext(), project2).invoke();
        final Bookmark bookmark = info.getBookmarkAtPlace();
        final BookmarkManager bookmarks = BookmarkManager.getInstance(project2);
        if (bookmark != null) {
            final JBPopup[] popup2 = new JBPopup[1];
            MnemonicChooser mc2 = new MnemonicChooser(){

                @Override
                protected void onMnemonicChosen(char c2) {
                    popup2[0].cancel();
                    bookmarks.setMnemonic(bookmark, c2);
                }

                @Override
                protected void onCancelled() {
                    popup2[0].cancel();
                    bookmarks.removeBookmark(bookmark);
                }

                @Override
                protected boolean isOccupied(char c2) {
                    return bookmarks.findBookmarkForMnemonic(c2) != null;
                }
            };
            popup2[0] = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mc2, (JComponent)mc2).setTitle("Bookmark Mnemonic").setFocusable(true).setRequestFocus(true).setMovable(false).setCancelKeyEnabled(false).setAdText(bookmarks.hasBookmarksWithMnemonics() ? (UIUtil.isUnderDarcula() ? "Brown" : "Yellow") + " cells are in use" : null).setResizable(false).createPopup();
            popup2[0].showInBestPositionFor(e2.getDataContext());
        }
    }
}

