/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BrowserSettingsPanel {
    private static final FileChooserDescriptor APP_FILE_CHOOSER_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String> PATH_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>("Path"){

        public String valueOf(ConfigurableWebBrowser item) {
            return PathUtil.toSystemDependentName((String)item.getPath());
        }

        public void setValue(ConfigurableWebBrowser item, String value2) {
            item.setPath(value2);
        }

        @Nullable
        public TableCellEditor getEditor(ConfigurableWebBrowser item) {
            return new LocalPathCellEditor().fileChooserDescriptor(APP_FILE_CHOOSER_DESCRIPTOR).normalizePath(true);
        }
    };
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean> ACTIVE_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean>(){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(ConfigurableWebBrowser item) {
            return item.isActive();
        }

        public void setValue(ConfigurableWebBrowser item, Boolean value2) {
            item.setActive(value2);
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{ACTIVE_COLUMN_INFO, new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>("Name"){

        public String valueOf(ConfigurableWebBrowser item) {
            return item.getName();
        }

        public void setValue(ConfigurableWebBrowser item, String value2) {
            item.setName(value2);
        }
    }, new ColumnInfo<ConfigurableWebBrowser, BrowserFamily>("Family"){

        public Class getColumnClass() {
            return BrowserFamily.class;
        }

        public BrowserFamily valueOf(ConfigurableWebBrowser item) {
            return item.getFamily();
        }

        public void setValue(ConfigurableWebBrowser item, BrowserFamily value2) {
            item.setFamily(value2);
            item.setSpecificSettings(value2.createBrowserSpecificSettings());
        }

        @Nullable
        public TableCellRenderer getRenderer(ConfigurableWebBrowser item) {
            return IconTableCellRenderer.ICONABLE;
        }

        public boolean isCellEditable(ConfigurableWebBrowser item) {
            return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
        }
    }, PATH_COLUMN_INFO};
    private JPanel root;
    private TextFieldWithBrowseButton alternativeBrowserPathField;
    private JPanel defaultBrowserPanel;
    private JComponent browsersTable;
    private ComboBox defaultBrowserPolicyComboBox;
    private JBCheckBox showBrowserHover;
    private TableModelEditor<ConfigurableWebBrowser> browsersEditor;
    private String customPathValue;

    public BrowserSettingsPanel() {
        this.$$$setupUI$$$();
        this.alternativeBrowserPathField.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, APP_FILE_CHOOSER_DESCRIPTOR);
        this.defaultBrowserPanel.setBorder(TitledSeparator.EMPTY_BORDER);
        ArrayList<DefaultBrowserPolicy> defaultBrowserPolicies = new ArrayList<DefaultBrowserPolicy>();
        if (BrowserLauncherAppless.canUseSystemDefaultBrowserPolicy()) {
            defaultBrowserPolicies.add(DefaultBrowserPolicy.SYSTEM);
        }
        defaultBrowserPolicies.add(DefaultBrowserPolicy.FIRST);
        defaultBrowserPolicies.add(DefaultBrowserPolicy.ALTERNATIVE);
        this.defaultBrowserPolicyComboBox.setModel((ComboBoxModel)new ListComboBoxModel(defaultBrowserPolicies));
        this.defaultBrowserPolicyComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e2) {
                boolean customPathEnabled;
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/BrowserSettingsPanel$5", "itemStateChanged"));
                }
                boolean bl = customPathEnabled = e2.getItem() == DefaultBrowserPolicy.ALTERNATIVE;
                if (e2.getStateChange() == 2) {
                    if (customPathEnabled) {
                        BrowserSettingsPanel.this.customPathValue = BrowserSettingsPanel.this.alternativeBrowserPathField.getText();
                    }
                } else if (e2.getStateChange() == 1) {
                    BrowserSettingsPanel.this.alternativeBrowserPathField.setEnabled(customPathEnabled);
                    BrowserSettingsPanel.this.updateCustomPathTextFieldValue((DefaultBrowserPolicy)((Object)e2.getItem()));
                }
            }
        });
        this.defaultBrowserPolicyComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DefaultBrowserPolicy>(){

            public void customize(JList list2, DefaultBrowserPolicy value2, int index, boolean selected, boolean hasFocus) {
                String name;
                switch (value2) {
                    case SYSTEM: {
                        name = "System default";
                        break;
                    }
                    case FIRST: {
                        name = "First listed";
                        break;
                    }
                    case ALTERNATIVE: {
                        name = "Custom path";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.setText(name);
            }
        });
        if (UIUtil.isUnderAquaLookAndFeel()) {
            this.defaultBrowserPolicyComboBox.setBorder((Border)new EmptyBorder(3, 0, 0, 0));
        }
    }

    private void updateCustomPathTextFieldValue(@NotNull DefaultBrowserPolicy browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/BrowserSettingsPanel", "updateCustomPathTextFieldValue"));
        }
        if (browser == DefaultBrowserPolicy.ALTERNATIVE) {
            this.alternativeBrowserPathField.setText(this.customPathValue);
        } else if (browser == DefaultBrowserPolicy.FIRST) {
            this.setCustomPathToFirstListed();
        } else {
            this.alternativeBrowserPathField.setText("");
        }
    }

    private void createUIComponents() {
        TableModelEditor.DialogItemEditor<ConfigurableWebBrowser> itemEditor = new TableModelEditor.DialogItemEditor<ConfigurableWebBrowser>(){

            @Override
            @NotNull
            public Class<ConfigurableWebBrowser> getItemClass() {
                if (ConfigurableWebBrowser.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "getItemClass"));
                }
                return ConfigurableWebBrowser.class;
            }

            @Override
            public ConfigurableWebBrowser clone(@NotNull ConfigurableWebBrowser item, boolean forInPlaceEditing) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "clone"));
                }
                return new ConfigurableWebBrowser(forInPlaceEditing ? item.getId() : UUID.randomUUID(), item.getFamily(), item.getName(), item.getPath(), item.isActive(), forInPlaceEditing ? item.getSpecificSettings() : this.cloneSettings(item));
            }

            @Override
            public void edit(@NotNull ConfigurableWebBrowser browser, @NotNull Function<ConfigurableWebBrowser, ConfigurableWebBrowser> mutator, boolean isAdd) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "edit"));
                }
                if (mutator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "edit"));
                }
                BrowserSpecificSettings settings = this.cloneSettings(browser);
                if (settings != null && ShowSettingsUtil.getInstance().editConfigurable((Component)BrowserSettingsPanel.this.browsersTable, settings.createConfigurable())) {
                    ((ConfigurableWebBrowser)((Object)mutator.fun((Object)browser))).setSpecificSettings(settings);
                }
            }

            @Nullable
            private BrowserSpecificSettings cloneSettings(@NotNull ConfigurableWebBrowser browser) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "cloneSettings"));
                }
                BrowserSpecificSettings settings = browser.getSpecificSettings();
                if (settings == null) {
                    return null;
                }
                BrowserSpecificSettings newSettings = browser.getFamily().createBrowserSpecificSettings();
                assert (newSettings != null);
                TableModelEditor.cloneUsingXmlSerialization(settings, newSettings);
                return newSettings;
            }

            @Override
            public void applyEdited(@NotNull ConfigurableWebBrowser oldItem, @NotNull ConfigurableWebBrowser newItem) {
                if (oldItem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "applyEdited"));
                }
                if (newItem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "applyEdited"));
                }
                oldItem.setSpecificSettings(newItem.getSpecificSettings());
            }

            @Override
            public boolean isEditable(@NotNull ConfigurableWebBrowser browser) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "isEditable"));
                }
                return browser.getSpecificSettings() != null;
            }

            @Override
            public boolean isRemovable(@NotNull ConfigurableWebBrowser item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/browsers/BrowserSettingsPanel$7", "isRemovable"));
                }
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        };
        this.browsersEditor = new TableModelEditor<ConfigurableWebBrowser>(COLUMNS, itemEditor, "No web browsers configured").modelListener(new TableModelEditor.DataChangedListener<ConfigurableWebBrowser>(){

            @Override
            public void tableChanged(@NotNull TableModelEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "tableChanged"));
                }
                this.update();
            }

            @Override
            public void dataChanged(@NotNull ColumnInfo<ConfigurableWebBrowser, ?> columnInfo, int rowIndex) {
                if (columnInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "dataChanged"));
                }
                if (columnInfo == PATH_COLUMN_INFO || columnInfo == ACTIVE_COLUMN_INFO) {
                    this.update();
                }
            }

            private void update() {
                if (BrowserSettingsPanel.this.getDefaultBrowser() == DefaultBrowserPolicy.FIRST) {
                    BrowserSettingsPanel.this.setCustomPathToFirstListed();
                }
            }
        });
        this.browsersTable = this.browsersEditor.createComponent();
    }

    private void setCustomPathToFirstListed() {
        ListTableModel<ConfigurableWebBrowser> model2 = this.browsersEditor.getModel();
        int n2 = model2.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ConfigurableWebBrowser browser = (ConfigurableWebBrowser)((Object)model2.getRowValue(i2));
            if (!browser.isActive() || browser.getPath() == null) continue;
            this.alternativeBrowserPathField.setText(browser.getPath());
            return;
        }
        this.alternativeBrowserPathField.setText("");
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.root;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserSettingsPanel", "getComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        DefaultBrowserPolicy defaultBrowserPolicy = this.getDefaultBrowser();
        if (BrowserSettingsPanel.getDefaultBrowserPolicy(browserManager) != defaultBrowserPolicy || browserManager.isShowBrowserHover() != this.showBrowserHover.isSelected()) {
            return true;
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE && !Comparing.strEqual((String)generalSettings.getBrowserPath(), (String)this.alternativeBrowserPathField.getText())) {
            return true;
        }
        return this.browsersEditor.isModified();
    }

    public void apply() {
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setUseDefaultBrowser(this.getDefaultBrowser() == DefaultBrowserPolicy.SYSTEM);
        if (this.alternativeBrowserPathField.isEnabled()) {
            settings.setBrowserPath(this.alternativeBrowserPathField.getText());
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        browserManager.setShowBrowserHover(this.showBrowserHover.isSelected());
        browserManager.defaultBrowserPolicy = this.getDefaultBrowser();
        browserManager.setList(this.browsersEditor.apply());
    }

    private DefaultBrowserPolicy getDefaultBrowser() {
        return (DefaultBrowserPolicy)((Object)this.defaultBrowserPolicyComboBox.getSelectedItem());
    }

    public void reset() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        DefaultBrowserPolicy effectiveDefaultBrowserPolicy = BrowserSettingsPanel.getDefaultBrowserPolicy(browserManager);
        this.defaultBrowserPolicyComboBox.setSelectedItem((Object)effectiveDefaultBrowserPolicy);
        GeneralSettings settings = GeneralSettings.getInstance();
        this.showBrowserHover.setSelected(browserManager.isShowBrowserHover());
        this.browsersEditor.reset(browserManager.getList());
        this.customPathValue = settings.getBrowserPath();
        this.alternativeBrowserPathField.setEnabled(effectiveDefaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE);
        this.updateCustomPathTextFieldValue(effectiveDefaultBrowserPolicy);
    }

    private static DefaultBrowserPolicy getDefaultBrowserPolicy(WebBrowserManager manager) {
        DefaultBrowserPolicy policy = manager.getDefaultBrowserPolicy();
        if (policy != DefaultBrowserPolicy.SYSTEM || BrowserLauncherAppless.canUseSystemDefaultBrowserPolicy()) {
            return policy;
        }
        return DefaultBrowserPolicy.ALTERNATIVE;
    }

    public void selectBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/BrowserSettingsPanel", "selectBrowser"));
        }
        if (browser instanceof ConfigurableWebBrowser) {
            this.browsersEditor.selectItem((ConfigurableWebBrowser)browser);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.root = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.defaultBrowserPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.alternativeBrowserPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.defaultBrowserPolicyComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Default Browser:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.browsersTable;
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.showBrowserHover = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show browser popup in the editor");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

