/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.BaseWebBrowserAction;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.util.CachedValueProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OpenInBrowserBaseGroupAction
extends ComputableActionGroup {
    private OpenFileInDefaultBrowserAction myDefaultBrowserAction;

    protected OpenInBrowserBaseGroupAction(boolean popup2) {
        super(popup2);
        Presentation p2 = this.getTemplatePresentation();
        p2.setText("Open in _Browser");
        p2.setDescription("Open selected file in browser");
        p2.setIcon(AllIcons.Nodes.PpWeb);
    }

    @Override
    @NotNull
    protected final CachedValueProvider<AnAction[]> createChildrenProvider(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction", "createChildrenProvider"));
        }
        CachedValueProvider cachedValueProvider = () -> {
            List<WebBrowser> browsers = WebBrowserManager.getInstance().getBrowsers();
            boolean addDefaultBrowser = this.isPopup();
            int offset = addDefaultBrowser ? 1 : 0;
            AnAction[] actions2 = new AnAction[browsers.size() + offset];
            if (addDefaultBrowser) {
                if (this.myDefaultBrowserAction == null) {
                    this.myDefaultBrowserAction = new OpenFileInDefaultBrowserAction();
                    this.myDefaultBrowserAction.getTemplatePresentation().setText("Default");
                    this.myDefaultBrowserAction.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
                }
                actions2[0] = this.myDefaultBrowserAction;
            }
            int size = browsers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                actions2[i2 + offset] = new BaseWebBrowserAction(browsers.get(i2));
            }
            return CachedValueProvider.Result.create((Object)actions2, (Object[])new Object[]{WebBrowserManager.getInstance()});
        };
        if (cachedValueProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction", "createChildrenProvider"));
        }
        return cachedValueProvider;
    }

    public static final class OpenInBrowserEditorContextBarGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserEditorContextBarGroupAction() {
            super(false);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserEditorContextBarGroupAction", "update"));
            }
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            e2.getPresentation().setVisible(browserManager.isShowBrowserHover() && !browserManager.getActiveBrowsers().isEmpty());
        }
    }

    public static final class OpenInBrowserGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserGroupAction() {
            super(true);
        }
    }
}

