/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomizeDesktopEntryStep
extends AbstractCustomizeWizardStep {
    private final JCheckBox myCreateEntryCheckBox = new JCheckBox(ActionsBundle.message((String)"action.CreateDesktopEntry.description", (Object[])new Object[0]));
    private final JCheckBox myGlobalEntryCheckBox = new JCheckBox("For all users (requires superuser privileges)");

    public static boolean isAvailable() {
        return System.getProperty("idea.skip.desktop.entry.step") == null && CreateDesktopEntryAction.isAvailable();
    }

    public CustomizeDesktopEntryStep(String iconPath) {
        this.setLayout(new BorderLayout());
        JPanel panel2 = CustomizeDesktopEntryStep.createBigButtonPanel(CustomizeDesktopEntryStep.createSmallBorderLayout(), this.myCreateEntryCheckBox, EmptyRunnable.INSTANCE);
        panel2.setBorder(CustomizeDesktopEntryStep.createSmallEmptyBorder());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        this.myCreateEntryCheckBox.setOpaque(false);
        buttonPanel.add((Component)this.myCreateEntryCheckBox, gbc.nextLine());
        this.myGlobalEntryCheckBox.setOpaque(false);
        gbc.nextLine().insets.left = UIUtil.PANEL_REGULAR_INSETS.left;
        buttonPanel.add((Component)this.myGlobalEntryCheckBox, gbc);
        panel2.add((Component)buttonPanel, "North");
        JLabel label = new JLabel(IconLoader.getIcon((String)iconPath));
        label.setVerticalAlignment(1);
        panel2.add((Component)label, "Center");
        this.add((Component)panel2, "Center");
        this.myCreateEntryCheckBox.addChangeListener(e2 -> this.myGlobalEntryCheckBox.setEnabled(this.myCreateEntryCheckBox.isSelected()));
        this.myCreateEntryCheckBox.setSelected(!"true".equals(System.getProperty("idea.debug.mode")));
        this.myGlobalEntryCheckBox.setSelected(false);
        this.myGlobalEntryCheckBox.setEnabled(this.myCreateEntryCheckBox.isSelected());
    }

    @Override
    public boolean beforeOkAction() {
        if (this.myCreateEntryCheckBox.isSelected()) {
            try {
                CreateDesktopEntryAction.createDesktopEntry(this.myGlobalEntryCheckBox.isSelected());
            }
            catch (Exception e2) {
                Messages.showErrorDialog((String)ExceptionUtil.getNonEmptyMessage((Throwable)e2, (String)"Internal error"), (String)"Desktop Entry Creation Failed");
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getTitle() {
        return "Desktop Entry";
    }

    @Override
    protected String getHTMLHeader() {
        return "<html><body><h2>Create Desktop Entry</h2>&nbsp;</body></html>";
    }

    @Override
    protected String getHTMLFooter() {
        return "Desktop entry can be created later in Tools | Create Desktop Entry...";
    }
}

