/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinuxDragAndDropSupport {
    public static final DataFlavor uriListFlavor = FileCopyPasteUtil.createDataFlavor("text/uri-list", String.class);
    public static final DataFlavor gnomeFileListFlavor = FileCopyPasteUtil.createDataFlavor("x-special/gnome-copied-files", null, true);
    public static final DataFlavor kdeCutMarkFlavor = FileCopyPasteUtil.createDataFlavor("application/x-kde-cutselection", null, true);

    private LinuxDragAndDropSupport() {
    }

    @Nullable
    public static List<File> getFiles(@NotNull Transferable transferable) throws IOException, UnsupportedFlavorException {
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/intellij/ide/dnd/LinuxDragAndDropSupport", "getFiles"));
        }
        if (transferable.isDataFlavorSupported(uriListFlavor)) {
            Object transferData = transferable.getTransferData(uriListFlavor);
            return LinuxDragAndDropSupport.getFiles(transferData.toString());
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            Object transferData = transferable.getTransferData(gnomeFileListFlavor);
            String content2 = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
            return LinuxDragAndDropSupport.getFiles(content2);
        }
        return null;
    }

    @NotNull
    private static List<File> getFiles(@Nullable String transferData) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (transferData != null) {
            String[] uriList;
            for (String uriString : uriList = StringUtil.convertLineSeparators((String)transferData).split("\n")) {
                if (StringUtil.isEmptyOrSpaces((String)uriString) || uriString.startsWith("#") || !uriString.startsWith("file:/")) continue;
                try {
                    URI uri2 = new URI(uriString);
                    fileList.add(new File(uri2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        ArrayList<File> arrayList = fileList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/dnd/LinuxDragAndDropSupport", "getFiles"));
        }
        return arrayList;
    }

    @NotNull
    public static String toUriList(@NotNull List<File> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/dnd/LinuxDragAndDropSupport", "toUriList"));
        }
        String string2 = StringUtil.join(files2, file2 -> file2.toURI().toString(), (String)"\n");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/dnd/LinuxDragAndDropSupport", "toUriList"));
        }
        return string2;
    }

    public static boolean isMoveOperation(@NotNull Transferable transferable) {
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/intellij/ide/dnd/LinuxDragAndDropSupport", "isMoveOperation"));
        }
        if (transferable.isDataFlavorSupported(gnomeFileListFlavor)) {
            try {
                Object transferData = transferable.getTransferData(gnomeFileListFlavor);
                String content2 = FileUtil.loadTextAndClose((InputStream)((InputStream)transferData));
                return content2.startsWith("cut\n");
            }
            catch (Exception exception) {}
        } else if (transferable.isDataFlavorSupported(kdeCutMarkFlavor)) {
            return true;
        }
        return false;
    }
}

