/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import javax.swing.JTree;

public class HotfixGroupElement
extends GroupingElement {
    private final Consumer<HotfixGate> myHotfix;
    private final String myFixDescription;
    private final MutableErrorTreeView myView;
    private boolean myInProgress;
    private final CustomizeColoredTreeCellRenderer myLeftTreeCellRenderer;
    private final CustomizeColoredTreeCellRenderer myRightTreeCellRenderer;

    public HotfixGroupElement(String name, Object data, VirtualFile file2, Consumer<HotfixGate> hotfix, String fixDescription, MutableErrorTreeView view2) {
        super(name, data, file2);
        this.myHotfix = hotfix;
        this.myFixDescription = fixDescription;
        this.myView = view2;
        this.myLeftTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

            public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                renderer.setIcon(AllIcons.General.Error);
                String[] text2 = HotfixGroupElement.this.getText();
                String errorText = text2 != null && text2.length > 0 ? text2[0] : "";
                renderer.append("Error: " + errorText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        };
        this.myRightTreeCellRenderer = new MyRightRenderer();
    }

    @Override
    public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
        return this.myLeftTreeCellRenderer;
    }

    @Override
    public CustomizeColoredTreeCellRenderer getRightSelfRenderer() {
        return this.myRightTreeCellRenderer;
    }

    private class MyRunner
    implements Runnable {
        private MyRunner() {
        }

        @Override
        public void run() {
            HotfixGroupElement.this.myInProgress = true;
            HotfixGroupElement.this.myView.reload();
            String name = HotfixGroupElement.this.getName();
            HotfixGroupElement.this.myHotfix.consume((Object)new HotfixGate(name, HotfixGroupElement.this.myView));
        }
    }

    private class MyRightRenderer
    extends CustomizeColoredTreeCellRenderer {
        private final MyRunner myRunner;

        public MyRightRenderer() {
            this.myRunner = new MyRunner();
        }

        public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            renderer.append(" ");
            if (HotfixGroupElement.this.myInProgress) {
                renderer.append("fixing...", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                renderer.append("Fix: " + HotfixGroupElement.this.myFixDescription, SimpleTextAttributes.LINK_BOLD_ATTRIBUTES, (Object)this.myRunner);
            }
        }

        public Object getTag() {
            return this.myRunner;
        }
    }
}

